/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.QueryException;
import com.mysema.query.types.EConstructor;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.BeanMap;

public class QBean<T>
extends EConstructor<T> {
    private static final long serialVersionUID = -8210214512730989778L;
    private final Map<String, Expr<?>> bindings;

    public QBean(Path<T> type, Expr<?> ... args) {
        this(type.getType(), args);
    }

    public QBean(Path<T> type, Map<String, Expr<?>> bindings) {
        this(type.getType(), bindings);
    }

    public QBean(Class<T> type, Map<String, Expr<?>> bindings) {
        super(type, new Class[0], new ArrayList(bindings.values()));
        this.bindings = bindings;
    }

    public QBean(Class<T> type, Expr<?> ... args) {
        super(type, new Class[0], args);
        this.bindings = this.createBindings(args);
    }

    private Map<String, Expr<?>> createBindings(Expr<?> ... args) {
        HashMap rv = new HashMap(args.length);
        for (Expr<?> expr : args) {
            if (expr instanceof Path) {
                Path path = (Path)((Object)expr);
                rv.put(path.getMetadata().getExpression().toString(), expr);
                continue;
            }
            if (expr instanceof Operation) {
                Operation operation = (Operation)((Object)expr);
                Path alias = (Path)((Object)operation.getArg(1));
                rv.put(alias.getMetadata().getExpression().toString(), expr);
                continue;
            }
            throw new IllegalArgumentException("Unsupported expression " + expr);
        }
        return rv;
    }

    @Override
    public T newInstance(Object ... args) {
        try {
            Object rv = this.getType().newInstance();
            List<Expr<?>> exprs = this.getArgs();
            BeanMap beanMap = new BeanMap(rv);
            for (Map.Entry<String, Expr<?>> entry : this.bindings.entrySet()) {
                beanMap.put(entry.getKey(), args[exprs.indexOf(entry.getValue())]);
            }
            return (T)rv;
        }
        catch (InstantiationException e) {
            throw new QueryException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new QueryException(e.getMessage(), e);
        }
    }
}

