/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Expr;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.expr.EDateOrTime;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ONumber;
import com.mysema.query.types.expr.OTime;
import java.util.Date;
import javax.annotation.Nullable;

public abstract class ETime<D extends Comparable>
extends EDateOrTime<D> {
    private static final long serialVersionUID = 7360552308332457990L;
    private static final ETime<Date> CURRENT_TIME = ETime.currentTime(Date.class);
    @Nullable
    private volatile ENumber<Integer> hours;
    @Nullable
    private volatile ENumber<Integer> minutes;
    @Nullable
    private volatile ENumber<Integer> seconds;
    @Nullable
    private volatile ENumber<Integer> milliseconds;

    public ETime(Class<? extends D> type) {
        super(type);
    }

    @Override
    public ETime<D> as(Path<D> alias) {
        return OTime.create(this.getType(), Ops.ALIAS, this, alias.asExpr());
    }

    public ENumber<Integer> hour() {
        if (this.hours == null) {
            this.hours = ONumber.create(Integer.class, Ops.DateTimeOps.HOUR, this);
        }
        return this.hours;
    }

    public ENumber<Integer> minute() {
        if (this.minutes == null) {
            this.minutes = ONumber.create(Integer.class, Ops.DateTimeOps.MINUTE, this);
        }
        return this.minutes;
    }

    public ENumber<Integer> second() {
        if (this.seconds == null) {
            this.seconds = ONumber.create(Integer.class, Ops.DateTimeOps.SECOND, this);
        }
        return this.seconds;
    }

    public ENumber<Integer> milliSecond() {
        if (this.milliseconds == null) {
            this.milliseconds = ONumber.create(Integer.class, Ops.DateTimeOps.MILLISECOND, this);
        }
        return this.milliseconds;
    }

    public static ETime<Date> currentTime() {
        return CURRENT_TIME;
    }

    public static <T extends Comparable> ETime<T> currentTime(Class<T> cl) {
        return OTime.create(cl, Ops.DateTimeOps.CURRENT_TIME, new Expr[0]);
    }
}

