/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Expr;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.expr.CaseForEqBuilder;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ECollection;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.expr.OBoolean;
import com.mysema.query.types.expr.ONumber;
import com.mysema.query.types.expr.OSimple;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class ESimple<D>
extends Expr<D> {
    private static final long serialVersionUID = -4405387187738167105L;
    @Nullable
    private volatile ENumber<Long> count;
    @Nullable
    private volatile ENumber<Long> countDistinct;

    public ESimple(Class<? extends D> type) {
        super(type);
    }

    public final ESimple<D> asExpr() {
        return this;
    }

    @Override
    public ENumber<Long> count() {
        if (this.count == null) {
            this.count = ONumber.create(Long.class, Ops.AggOps.COUNT_AGG, this);
        }
        return this.count;
    }

    @Override
    public ENumber<Long> countDistinct() {
        if (this.countDistinct == null) {
            this.countDistinct = ONumber.create(Long.class, Ops.AggOps.COUNT_DISTINCT_AGG, this);
        }
        return this.countDistinct;
    }

    @Override
    public EBoolean eq(D right) {
        return this.eq(ExprConst.create(right));
    }

    @Override
    public EBoolean eq(Expr<? super D> right) {
        if (this.primitive) {
            return OBoolean.create(Ops.EQ_PRIMITIVE, this, right);
        }
        return OBoolean.create(Ops.EQ_OBJECT, this, right);
    }

    @Override
    public EBoolean in(Collection<? extends D> right) {
        if (right.size() == 1) {
            return this.eq(right.iterator().next());
        }
        return OBoolean.create(Ops.IN, this, ExprConst.create(right));
    }

    @Override
    public EBoolean in(D ... right) {
        if (right.length == 1) {
            return this.eq(right[0]);
        }
        return OBoolean.create(Ops.IN, this, ExprConst.create(Arrays.asList(right)));
    }

    @Override
    public EBoolean in(ECollection<?, ? extends D> right) {
        return OBoolean.create(Ops.IN, this, (Expr)((Object)right));
    }

    @Override
    public EBoolean ne(D right) {
        return this.ne(ExprConst.create(right));
    }

    @Override
    public EBoolean ne(Expr<? super D> right) {
        if (this.primitive) {
            return OBoolean.create(Ops.NE_PRIMITIVE, this, right);
        }
        return OBoolean.create(Ops.NE_OBJECT, this, right);
    }

    public CaseForEqBuilder<D> when(D other) {
        return new CaseForEqBuilder<D>(this, ExprConst.create(other));
    }

    public CaseForEqBuilder<D> when(Expr<? extends D> other) {
        return new CaseForEqBuilder<D>(this, other);
    }

    @Override
    public Expr<D> as(Path<D> alias) {
        return OSimple.create(this.getType(), Ops.ALIAS, this, alias.asExpr());
    }
}

