/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.BooleanBuilder;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Interval;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EComparableBase;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.expr.OBoolean;
import com.mysema.query.types.expr.OComparable;

public abstract class EComparable<D extends Comparable>
extends EComparableBase<D> {
    private static final long serialVersionUID = 5761359576767404270L;

    public EComparable(Class<? extends D> type) {
        super(type);
    }

    @Override
    public EComparable<D> as(Path<D> alias) {
        return OComparable.create(this.getType(), Ops.ALIAS, this, alias.asExpr());
    }

    public final EBoolean between(D from, D to) {
        return OBoolean.create(Ops.BETWEEN, this, ExprConst.create(from), ExprConst.create(to));
    }

    public final EBoolean between(Expr<D> from, Expr<D> to) {
        return OBoolean.create(Ops.BETWEEN, this, from, to);
    }

    public final EBoolean notBetween(D from, D to) {
        return this.between(from, to).not();
    }

    public final EBoolean notBetween(Expr<D> from, Expr<D> to) {
        return this.between(from, to).not();
    }

    public EBoolean gt(D right) {
        return this.gt(ExprConst.create(right));
    }

    public EBoolean gt(Expr<D> right) {
        return OBoolean.create(Ops.AFTER, this, right);
    }

    public EBoolean goe(D right) {
        return this.goe(ExprConst.create(right));
    }

    public EBoolean goe(Expr<D> right) {
        return OBoolean.create(Ops.AOE, this, right);
    }

    public final EBoolean lt(D right) {
        return this.lt(ExprConst.create(right));
    }

    public final EBoolean lt(Expr<D> right) {
        return OBoolean.create(Ops.BEFORE, this, right);
    }

    public final EBoolean loe(D right) {
        return OBoolean.create(Ops.BOE, this, ExprConst.create(right));
    }

    public final EBoolean loe(Expr<D> right) {
        return OBoolean.create(Ops.BOE, this, right);
    }

    @Override
    public EBoolean in(Interval<D> period) {
        BooleanBuilder builder = new BooleanBuilder();
        if (period.getBegin() != null) {
            builder.and(this.goe((Comparable)period.getBegin()));
        }
        if (period.getEnd() != null) {
            builder.and(this.loe((Comparable)period.getEnd()));
        }
        return builder.getValue();
    }
}

