/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Constant;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;

public final class EBooleanConst
extends EBoolean
implements Constant<Boolean> {
    public static final EBoolean FALSE = new EBooleanConst(Boolean.FALSE);
    private static final long serialVersionUID = -4106376704553234781L;
    public static final EBoolean TRUE = new EBooleanConst(Boolean.TRUE);
    private final Boolean constant;

    public static EBoolean create(Boolean b) {
        return b != false ? TRUE : FALSE;
    }

    private EBooleanConst(Boolean b) {
        this.constant = b;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public EBoolean eq(Boolean b) {
        return this.constant.equals(b) ? TRUE : FALSE;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Constant) {
            Constant c = (Constant)o;
            return c.getConstant().equals(this.constant);
        }
        return false;
    }

    @Override
    public Boolean getConstant() {
        return this.constant;
    }

    @Override
    public int hashCode() {
        return this.constant.hashCode();
    }

    @Override
    public EBoolean ne(Boolean b) {
        return this.constant.equals(b) ? FALSE : TRUE;
    }

    @Override
    public EBoolean not() {
        return this.constant != false ? FALSE : TRUE;
    }
}

