/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Expr;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EComparable;
import com.mysema.query.types.expr.EDate;
import com.mysema.query.types.expr.EDateTime;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.EString;
import com.mysema.query.types.expr.ETime;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.expr.ODate;
import com.mysema.query.types.expr.ODateTime;
import com.mysema.query.types.expr.ONumber;
import com.mysema.query.types.expr.OSimple;
import com.mysema.query.types.expr.OString;
import com.mysema.query.types.expr.OTime;
import java.util.ArrayList;
import java.util.List;

public class Coalesce<T extends Comparable>
extends EComparable<T> {
    private static final long serialVersionUID = 445439522266250417L;
    private final List<Expr<? extends T>> exprs = new ArrayList<Expr<? extends T>>();

    public Coalesce(Class<? extends T> type, Expr ... exprs) {
        super(type);
        for (Expr expr : exprs) {
            this.add((T)expr);
        }
    }

    public Coalesce(Expr ... exprs) {
        this(exprs.length > 0 ? exprs[0].getType() : Object.class, exprs);
    }

    @Override
    public void accept(Visitor v) {
        OSimple.create(this.getType(), Ops.COALESCE, this.getExpressionList()).accept(v);
    }

    public final Coalesce<T> add(Expr<T> expr) {
        this.exprs.add(expr);
        return this;
    }

    public final Coalesce<T> add(T constant) {
        this.exprs.add(ExprConst.create(constant));
        return this;
    }

    public EDate<T> asDate() {
        return ODate.create(this.getType(), Ops.COALESCE, this.getExpressionList());
    }

    public EDateTime<T> asDateTime() {
        return ODateTime.create(this.getType(), Ops.COALESCE, this.getExpressionList());
    }

    public ENumber<?> asNumber() {
        return ONumber.create(this.getType(), Ops.COALESCE, this.getExpressionList());
    }

    public EString asString() {
        return OString.create(Ops.COALESCE, this.getExpressionList());
    }

    public ETime<T> asTime() {
        return OTime.create(this.getType(), Ops.COALESCE, this.getExpressionList());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Coalesce) {
            Coalesce c = (Coalesce)o;
            return ((Object)c.exprs).equals(this.exprs);
        }
        return false;
    }

    private Expr<?> getExpressionList() {
        Expr<Object> arg = this.exprs.get(0);
        for (int i = 1; i < this.exprs.size(); ++i) {
            arg = OSimple.create(List.class, Ops.LIST, arg, this.exprs.get(i));
        }
        return arg;
    }

    @Override
    public int hashCode() {
        return ((Object)this.exprs).hashCode();
    }
}

