/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Expr;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathType;
import java.io.Serializable;
import javax.annotation.Nullable;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@Immutable
public final class PathMetadata<T>
implements Serializable {
    private static final long serialVersionUID = -1055994185028970065L;
    private final Expr<T> expression;
    private final int hashCode;
    @Nullable
    private final Path<?> parent;
    @Nullable
    private final Path<?> root;
    private final PathType pathType;

    public PathMetadata(@Nullable Path<?> parent, Expr<T> expression, PathType type) {
        this.parent = parent;
        this.expression = expression;
        this.pathType = type;
        this.root = parent != null ? parent.getRoot() : null;
        this.hashCode = new HashCodeBuilder().append(expression).append(parent).append((Object)this.pathType).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PathMetadata) {
            PathMetadata p = (PathMetadata)obj;
            return new EqualsBuilder().append(this.expression, p.expression).append(this.parent, p.parent).append((Object)this.pathType, (Object)p.pathType).isEquals();
        }
        return false;
    }

    public Expr<T> getExpression() {
        return this.expression;
    }

    @Nullable
    public Path<?> getParent() {
        return this.parent;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    @Nullable
    public Path<?> getRoot() {
        return this.root;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isRoot() {
        return this.parent == null;
    }
}

