/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Path;
import com.mysema.query.types.Templates;
import com.mysema.query.types.ToStringVisitor;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ECollection;
import com.mysema.query.types.expr.ENumber;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class Expr<D>
implements Serializable {
    private static final long serialVersionUID = 8049453060731070043L;
    protected final boolean primitive;
    @Nullable
    private volatile String toString;
    private final Class<? extends D> type;

    public Expr(Class<? extends D> type) {
        this.type = (Class)Assert.notNull(type, (String)"type");
        this.primitive = type.isPrimitive() || Number.class.isAssignableFrom(type) || Boolean.class.equals(type) || Character.class.equals(type);
    }

    public abstract void accept(Visitor var1);

    public abstract Expr<D> as(Path<D> var1);

    public abstract ENumber<Long> count();

    public abstract ENumber<Long> countDistinct();

    public abstract EBoolean eq(D var1);

    public abstract EBoolean eq(Expr<? super D> var1);

    public final Class<? extends D> getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public abstract boolean equals(Object var1);

    public abstract EBoolean in(Collection<? extends D> var1);

    public abstract EBoolean in(D ... var1);

    public abstract EBoolean in(ECollection<?, ? extends D> var1);

    public abstract EBoolean ne(D var1);

    public abstract EBoolean ne(Expr<? super D> var1);

    public final EBoolean notIn(Collection<? extends D> right) {
        if (right.size() == 1) {
            return this.ne(right.iterator().next());
        }
        return this.in(right).not();
    }

    public EBoolean notIn(D ... right) {
        if (right.length == 1) {
            return this.ne(right[0]);
        }
        return this.in(right).not();
    }

    public final EBoolean notIn(ECollection<?, ? extends D> right) {
        return this.in(right).not();
    }

    public final String toString() {
        if (this.toString == null) {
            ToStringVisitor visitor = new ToStringVisitor(Templates.DEFAULT);
            this.accept(visitor);
            this.toString = ((Object)visitor).toString();
        }
        return this.toString;
    }
}

