/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Expr;
import com.mysema.query.types.expr.EString;
import com.mysema.query.types.expr.EStringEscape;

interface Converter<S extends Expr<?>, T extends Expr<?>> {
    public static final Converter<EString, EString> toLowerCase = new Converter<EString, EString>(){

        @Override
        public EString convert(EString arg) {
            return arg.toLowerCase();
        }
    };
    public static final Converter<EString, EString> toUpperCase = new Converter<EString, EString>(){

        @Override
        public EString convert(EString arg) {
            return arg.toUpperCase();
        }
    };
    public static final Converter<EString, EString> toStartsWithViaLike = new Converter<EString, EString>(){

        @Override
        public EString convert(EString arg) {
            return EStringEscape.escapeForLike(arg).append("%");
        }
    };
    public static final Converter<EString, EString> toStartsWithViaLikeLower = new Converter<EString, EString>(){

        @Override
        public EString convert(EString arg) {
            return EStringEscape.escapeForLike(arg).append("%").lower();
        }
    };
    public static final Converter<EString, EString> toEndsWithViaLike = new Converter<EString, EString>(){

        @Override
        public EString convert(EString arg) {
            return EStringEscape.escapeForLike(arg).prepend("%");
        }
    };
    public static final Converter<EString, EString> toEndsWithViaLikeLower = new Converter<EString, EString>(){

        @Override
        public EString convert(EString arg) {
            return EStringEscape.escapeForLike(arg).prepend("%").lower();
        }
    };
    public static final Converter<EString, EString> toContainsViaLike = new Converter<EString, EString>(){

        @Override
        public EString convert(EString arg) {
            return EStringEscape.escapeForLike(arg).prepend("%").append("%");
        }
    };
    public static final Converter<EString, EString> toContainsViaLikeLower = new Converter<EString, EString>(){

        @Override
        public EString convert(EString arg) {
            return EStringEscape.escapeForLike(arg).prepend("%").append("%").lower();
        }
    };

    public T convert(S var1);
}

