/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.commons.lang.Assert;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.types.Expr;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Param;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQuery;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.path.PEntity;

public class QueryMixin<T> {
    private final QueryMetadata metadata;
    private T self;

    public QueryMixin() {
        this.metadata = new DefaultQueryMetadata();
    }

    public QueryMixin(QueryMetadata metadata) {
        this.metadata = (QueryMetadata)Assert.notNull((Object)metadata, (String)"metadata");
    }

    public QueryMixin(T self) {
        this(self, new DefaultQueryMetadata());
    }

    public QueryMixin(T self, QueryMetadata metadata) {
        this.self = Assert.notNull(self, (String)"self");
        this.metadata = (QueryMetadata)Assert.notNull((Object)metadata, (String)"metadata");
    }

    public T addFlag(QueryFlag queryFlag) {
        this.metadata.addFlag(queryFlag);
        return this.self;
    }

    public T addToProjection(Expr<?> ... o) {
        this.metadata.addProjection(o);
        return this.self;
    }

    public T from(Expr<?> ... args) {
        for (Expr<?> arg : args) {
            this.metadata.addJoin(JoinType.DEFAULT, arg);
        }
        return this.self;
    }

    public <P> T fullJoin(PEntity<P> target) {
        this.metadata.addJoin(JoinType.FULLJOIN, target);
        return this.self;
    }

    public <P> T fullJoin(SubQuery<P> target, Path alias) {
        this.metadata.addJoin(JoinType.FULLJOIN, target.asExpr().as(alias));
        return this.self;
    }

    public QueryMetadata getMetadata() {
        return this.metadata;
    }

    public T getSelf() {
        return this.self;
    }

    public T groupBy(Expr<?> ... o) {
        this.metadata.addGroupBy(o);
        return this.self;
    }

    public T having(EBoolean ... o) {
        this.metadata.addHaving(o);
        return this.self;
    }

    public <P> T innerJoin(PEntity<P> target) {
        this.metadata.addJoin(JoinType.INNERJOIN, target);
        return this.self;
    }

    public <P> T innerJoin(SubQuery<P> target, Path alias) {
        this.metadata.addJoin(JoinType.INNERJOIN, target.asExpr().as(alias));
        return this.self;
    }

    public boolean isDistinct() {
        return this.metadata.isDistinct();
    }

    public boolean isUnique() {
        return this.metadata.isUnique();
    }

    public <P> T join(PEntity<P> target) {
        this.metadata.addJoin(JoinType.JOIN, target);
        return this.self;
    }

    public <P> T join(SubQuery<P> target, Path alias) {
        this.metadata.addJoin(JoinType.JOIN, target.asExpr().as(alias));
        return this.self;
    }

    public <P> T leftJoin(PEntity<P> target) {
        this.metadata.addJoin(JoinType.LEFTJOIN, target);
        return this.self;
    }

    public <P> T leftJoin(SubQuery<P> target, Path alias) {
        this.metadata.addJoin(JoinType.LEFTJOIN, target.asExpr().as(alias));
        return this.self;
    }

    public T limit(long limit) {
        this.metadata.setLimit(limit);
        return this.self;
    }

    public T offset(long offset) {
        this.metadata.setOffset(offset);
        return this.self;
    }

    public T on(EBoolean ... conditions) {
        for (EBoolean condition : conditions) {
            this.metadata.addJoinCondition(condition);
        }
        return this.self;
    }

    public T orderBy(OrderSpecifier<?> ... o) {
        this.metadata.addOrderBy(o);
        return this.self;
    }

    public T restrict(QueryModifiers modifiers) {
        this.metadata.setModifiers(modifiers);
        return this.self;
    }

    public <P> T rightJoin(PEntity<P> target) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, target);
        return this.self;
    }

    public <P> T rightJoin(SubQuery<P> target, Path alias) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, target.asExpr().as(alias));
        return this.self;
    }

    public <P> T set(Param<P> param, P value) {
        this.metadata.setParam(param, value);
        return this.self;
    }

    public void setDistinct(boolean distinct) {
        this.metadata.setDistinct(distinct);
    }

    public void setSelf(T self) {
        this.self = self;
    }

    public void setUnique(boolean unique) {
        this.metadata.setUnique(unique);
    }

    public String toString() {
        return this.metadata.toString();
    }

    public T where(EBoolean ... o) {
        this.metadata.addWhere(o);
        return this.self;
    }
}

