/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.serialization;

import com.mysema.commons.lang.Assert;
import com.mysema.query.BooleanBuilder;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryFlag;
import com.mysema.query.types.Constant;
import com.mysema.query.types.Custom;
import com.mysema.query.types.EConstructor;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Param;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathType;
import com.mysema.query.types.Template;
import com.mysema.query.types.Templates;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SerializerBase<S extends SerializerBase<S>>
implements Visitor {
    private final StringBuilder builder = new StringBuilder();
    private String constantPrefix = "a";
    private String paramPrefix = "p";
    private String anonParamPrefix = "_";
    private final Map<Object, String> constantToLabel = new HashMap<Object, String>();
    private final S self = this;
    private final Templates templates;

    public SerializerBase(Templates patterns) {
        this.templates = (Templates)Assert.notNull((Object)patterns, (String)"patterns");
    }

    public S append(String ... str) {
        for (String s : str) {
            this.builder.append(s);
        }
        return this.self;
    }

    protected String getConstantPrefix() {
        return this.constantPrefix;
    }

    public Map<Object, String> getConstantToLabel() {
        return this.constantToLabel;
    }

    protected Template getTemplate(Operator<?> op) {
        return this.templates.getTemplate(op);
    }

    public S handle(Expr<?> expr) {
        expr.accept(this);
        return this.self;
    }

    public S handle(JoinFlag joinFlag) {
        return this.handle(joinFlag.getFlag());
    }

    public final S handle(String sep, List<?> expressions) {
        boolean first = true;
        for (Object expr : expressions) {
            if (!first) {
                this.append(sep);
            }
            if (!(expr instanceof Expr)) {
                throw new IllegalArgumentException("Unsupported type " + expr.getClass().getName());
            }
            this.handle((Expr)expr);
            first = false;
        }
        return this.self;
    }

    private void handleTemplate(Template template, List<Expr<?>> args) {
        for (Template.Element element : template.getElements()) {
            if (element.getStaticText() != null) {
                this.append(element.getStaticText());
                continue;
            }
            if (element.isAsString()) {
                this.append(args.get(element.getIndex()).toString());
                continue;
            }
            if (element.hasConverter()) {
                this.handle(element.convert(args.get(element.getIndex())));
                continue;
            }
            this.handle(args.get(element.getIndex()));
        }
    }

    protected void serialize(QueryFlag.Position position, Set<QueryFlag> flags) {
        for (QueryFlag flag : flags) {
            if (flag.getPosition() != position) continue;
            this.handle(flag.getFlag());
        }
    }

    public void setConstantPrefix(String prefix) {
        this.constantPrefix = prefix;
    }

    public void setParamPrefix(String prefix) {
        this.paramPrefix = prefix;
    }

    public void setAnonParamPrefix(String prefix) {
        this.anonParamPrefix = prefix;
    }

    public String toString() {
        return this.builder.toString();
    }

    @Override
    public void visit(Constant<?> expr) {
        if (!this.constantToLabel.containsKey(expr.getConstant())) {
            String constLabel = this.constantPrefix + (this.constantToLabel.size() + 1);
            this.constantToLabel.put(expr.getConstant(), constLabel);
            this.append(constLabel);
        } else {
            this.append(this.constantToLabel.get(expr.getConstant()));
        }
    }

    @Override
    public void visit(Param<?> param) {
        String paramLabel = param.isAnon() ? this.anonParamPrefix + param.getName() : this.paramPrefix + param.getName();
        this.constantToLabel.put(param, paramLabel);
        this.append(paramLabel);
    }

    @Override
    public void visit(Custom<?> expr) {
        this.handleTemplate(expr.getTemplate(), expr.getArgs());
    }

    @Override
    public void visit(EConstructor<?> expr) {
        this.handle(", ", expr.getArgs());
    }

    @Override
    public void visit(Operation<?> expr) {
        this.visitOperation(expr.getType(), expr.getOperator(), expr.getArgs());
    }

    @Override
    public void visit(Path<?> path) {
        PathType pathType = path.getMetadata().getPathType();
        Template template = this.templates.getTemplate(pathType);
        ArrayList args = new ArrayList();
        if (path.getMetadata().getParent() != null) {
            args.add((Expr)((Object)path.getMetadata().getParent()));
        }
        args.add(path.getMetadata().getExpression());
        this.handleTemplate(template, args);
    }

    protected void visitOperation(Class<?> type, Operator<?> operator, List<Expr<?>> args) {
        Template template = this.templates.getTemplate(operator);
        if (template == null) {
            throw new IllegalArgumentException("Got no pattern for " + operator);
        }
        int precedence = this.templates.getPrecedence(operator);
        for (Template.Element element : template.getElements()) {
            if (element.getStaticText() != null) {
                this.append(element.getStaticText());
                continue;
            }
            if (element.isAsString()) {
                this.append(args.get(element.getIndex()).toString());
                continue;
            }
            int i = element.getIndex();
            boolean wrap = false;
            EBoolean arg = args.get(i);
            if (arg instanceof BooleanBuilder) {
                arg = ((BooleanBuilder)arg).getValue();
            }
            if (arg instanceof Operation) {
                boolean bl = wrap = precedence < this.templates.getPrecedence(((Operation)((Object)arg)).getOperator());
            }
            if (wrap) {
                this.append("(");
            }
            if (element.hasConverter()) {
                this.handle(element.convert(arg));
            } else {
                this.handle(arg);
            }
            if (!wrap) continue;
            this.append(")");
        }
    }
}

