/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.Types;
import com.mysema.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;

public final class TypeFactory {
    private final Map<List<java.lang.reflect.Type>, Type> cache = new HashMap<List<java.lang.reflect.Type>, Type>();
    private final Collection<Class<? extends Annotation>> entityAnnotations;

    public TypeFactory(Class<?> ... entityAnnotations) {
        this.entityAnnotations = Arrays.asList(entityAnnotations);
    }

    public TypeFactory(List<Class<? extends Annotation>> entityAnnotations) {
        this.entityAnnotations = entityAnnotations;
    }

    public Type create(Class<?> cl) {
        return this.create(cl, cl);
    }

    public Type create(Class<?> cl, java.lang.reflect.Type genericType) {
        Type valueInfo;
        ClassType value;
        List<java.lang.reflect.Type> key = Arrays.asList(cl, genericType);
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        if (cl.isPrimitive()) {
            cl = ClassUtils.primitiveToWrapper(cl);
        }
        boolean entity = false;
        for (Class<? extends Annotation> clazz : this.entityAnnotations) {
            if (cl.getAnnotation(clazz) == null) continue;
            entity = true;
            break;
        }
        if (entity) {
            value = new ClassType(TypeCategory.ENTITY, cl, new Type[0]);
        } else if (cl.isArray()) {
            value = this.create(cl.getComponentType()).asArrayType();
        } else if (cl.isEnum()) {
            value = new ClassType(TypeCategory.SIMPLE, cl, new Type[0]);
        } else if (Map.class.isAssignableFrom(cl)) {
            Type keyInfo = this.create(ReflectionUtils.getTypeParameter(genericType, 0));
            Type valueInfo2 = this.create(ReflectionUtils.getTypeParameter(genericType, 1));
            value = new SimpleType((Type)Types.MAP, new Type[]{keyInfo, valueInfo2});
        } else if (List.class.isAssignableFrom(cl)) {
            valueInfo = this.create(ReflectionUtils.getTypeParameter(genericType, 0));
            value = new SimpleType((Type)Types.LIST, new Type[]{valueInfo});
        } else if (Set.class.isAssignableFrom(cl)) {
            valueInfo = this.create(ReflectionUtils.getTypeParameter(genericType, 0));
            value = new SimpleType((Type)Types.SET, new Type[]{valueInfo});
        } else if (Collection.class.isAssignableFrom(cl)) {
            valueInfo = this.create(ReflectionUtils.getTypeParameter(genericType, 0));
            value = new SimpleType((Type)Types.COLLECTION, new Type[]{valueInfo});
        } else if (Number.class.isAssignableFrom(cl) && Comparable.class.isAssignableFrom(cl)) {
            value = new ClassType(TypeCategory.NUMERIC, cl, new Type[0]);
        } else {
            TypeCategory typeCategory = TypeCategory.get((String)cl.getName());
            if (!typeCategory.isSubCategoryOf(TypeCategory.COMPARABLE) && Comparable.class.isAssignableFrom(cl)) {
                typeCategory = TypeCategory.COMPARABLE;
            }
            value = new ClassType(typeCategory, cl, new Type[0]);
        }
        this.cache.put(key, (Type)value);
        return value;
    }
}

