/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Expr;
import com.mysema.query.types.custom.CString;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

@Immutable
public class QueryFlag
implements Serializable {
    private static final long serialVersionUID = -7131081607441961628L;
    private final Position position;
    private final Expr<?> flag;

    public QueryFlag(Position position, String flag) {
        this(position, CString.create(flag, new Expr[0]));
    }

    public QueryFlag(Position position, Expr<?> flag) {
        this.position = (Position)((Object)Assert.notNull((Object)((Object)position), (String)"position"));
        this.flag = (Expr)Assert.notNull(flag, (String)"flag");
    }

    public Position getPosition() {
        return this.position;
    }

    public Expr<?> getFlag() {
        return this.flag;
    }

    public int hashCode() {
        return this.flag.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QueryFlag) {
            QueryFlag other = (QueryFlag)obj;
            return other.position.equals((Object)this.position) && other.flag.equals(this.flag);
        }
        return false;
    }

    public String toString() {
        return (Object)((Object)this.position) + " : " + this.flag;
    }

    public static enum Position {
        START,
        AFTER_SELECT,
        AFTER_PROJECTION,
        BEFORE_FILTERS,
        AFTER_FILTERS,
        BEFORE_GROUP_BY,
        AFTER_GROUP_BY,
        BEFORE_HAVING,
        AFTER_HAVING,
        BEFORE_ORDER,
        AFTER_ORDER,
        END;

    }
}

