/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query;

import com.mysema.commons.lang.Assert;
import com.mysema.query.BooleanBuilder;
import com.mysema.query.JoinFlag;
import com.mysema.query.JoinType;
import com.mysema.query.types.Expr;
import com.mysema.query.types.expr.EBoolean;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;

public final class JoinExpression
implements Serializable {
    private static final long serialVersionUID = -1131755765747174886L;
    private BooleanBuilder condition = new BooleanBuilder();
    private final Set<JoinFlag> flags = new LinkedHashSet<JoinFlag>();
    private final Expr<?> target;
    private final JoinType type;

    public JoinExpression(JoinType type, Expr<?> target) {
        this.type = (JoinType)((Object)Assert.notNull((Object)((Object)type), (String)"type"));
        this.target = (Expr)Assert.notNull(target, (String)"target");
    }

    public EBoolean getCondition() {
        return this.condition.getValue();
    }

    public void addCondition(EBoolean c) {
        this.condition.and(c);
    }

    public Expr<?> getTarget() {
        return this.target;
    }

    public JoinType getType() {
        return this.type;
    }

    public void addFlag(JoinFlag flag) {
        this.flags.add(flag);
    }

    public boolean hasFlag(JoinFlag flag) {
        return this.flags.contains(flag);
    }

    public Set<JoinFlag> getFlags() {
        return this.flags;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.type).append(" ").append(this.target);
        if (this.condition.getValue() != null) {
            builder.append(" ON ").append(this.condition);
        }
        return builder.toString();
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JoinExpression) {
            JoinExpression j = (JoinExpression)o;
            return new EqualsBuilder().append((Object)this.condition, (Object)j.condition).append(this.target, j.target).append((Object)this.type, (Object)j.type).isEquals();
        }
        return false;
    }
}

