/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query;

import com.mysema.query.QueryException;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Operator;
import com.mysema.query.types.PathType;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.ObjectUtils;

public final class BooleanBuilder
extends EBoolean
implements Cloneable,
Operation<Boolean> {
    private static final long serialVersionUID = -4129485177345542519L;
    @Nullable
    private EBoolean expr;

    public BooleanBuilder() {
    }

    public BooleanBuilder(EBoolean initial) {
        this.expr = initial;
    }

    @Override
    public void accept(Visitor v) {
        if (this.expr == null) {
            throw new QueryException("BooleanBuilder has no value");
        }
        this.expr.accept(v);
    }

    @Override
    public BooleanBuilder and(@Nullable EBoolean right) {
        if (right != null) {
            this.expr = this.expr == null ? right : this.expr.and(right);
        }
        return this;
    }

    public BooleanBuilder andAnyOf(EBoolean ... args) {
        if (args.length > 0) {
            this.and(BooleanBuilder.anyOf(args));
        }
        return this;
    }

    public BooleanBuilder andNot(EBoolean right) {
        return this.and(right.not());
    }

    public BooleanBuilder clone() throws CloneNotSupportedException {
        return (BooleanBuilder)super.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BooleanBuilder) {
            return ObjectUtils.equals((Object)((BooleanBuilder)o).getValue(), (Object)this.expr);
        }
        return false;
    }

    @Override
    public Expr<?> getArg(int index) {
        if (index == 0) {
            return this.expr;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public List<Expr<?>> getArgs() {
        return Collections.singletonList(this.expr);
    }

    @Override
    public Operator<? super Boolean> getOperator() {
        return PathType.DELEGATE;
    }

    @Nullable
    public EBoolean getValue() {
        return this.expr;
    }

    @Override
    public int hashCode() {
        return this.expr != null ? this.expr.hashCode() : super.hashCode();
    }

    public boolean hasValue() {
        return this.expr != null;
    }

    @Override
    public BooleanBuilder not() {
        if (this.expr != null) {
            this.expr = this.expr.not();
        }
        return this;
    }

    @Override
    public BooleanBuilder or(@Nullable EBoolean right) {
        if (right != null) {
            this.expr = this.expr == null ? right : this.expr.or(right);
        }
        return this;
    }

    public BooleanBuilder orAllOf(EBoolean ... args) {
        if (args.length > 0) {
            this.or(BooleanBuilder.allOf(args));
        }
        return this;
    }

    public BooleanBuilder orNot(EBoolean right) {
        return this.or(right.not());
    }
}

