/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Constant;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EDateConst;
import com.mysema.query.types.expr.EDateTime;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ETimeConst;
import java.util.Date;

public final class EDateTimeConst<D extends Date>
extends EDateTime<D>
implements Constant<D> {
    private static final long serialVersionUID = 4578416585568476532L;
    private final EDateConst<D> date;
    private final ETimeConst<D> time;

    public static <D extends Date> EDateTime<D> create(D date) {
        return new EDateTimeConst<D>(date);
    }

    public EDateTimeConst(D date) {
        super(date.getClass());
        this.date = new EDateConst<D>(date);
        this.time = new ETimeConst<D>(date);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public ENumber<Integer> dayOfMonth() {
        return this.date.dayOfMonth();
    }

    @Override
    public ENumber<Integer> month() {
        return this.date.month();
    }

    @Override
    public ENumber<Integer> year() {
        return this.date.year();
    }

    @Override
    public ENumber<Integer> yearMonth() {
        return this.date.yearMonth();
    }

    @Override
    public ENumber<Integer> dayOfWeek() {
        return this.date.dayOfWeek();
    }

    @Override
    public ENumber<Integer> dayOfYear() {
        return this.date.dayOfYear();
    }

    @Override
    public ENumber<Integer> week() {
        return this.date.week();
    }

    @Override
    public ENumber<Integer> hour() {
        return this.time.hour();
    }

    @Override
    public ENumber<Integer> minute() {
        return this.time.minute();
    }

    @Override
    public ENumber<Integer> second() {
        return this.time.second();
    }

    @Override
    public ENumber<Integer> milliSecond() {
        return this.time.milliSecond();
    }

    @Override
    public D getConstant() {
        return (D)this.date.getConstant();
    }

    @Override
    public int hashCode() {
        return this.date.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Constant) {
            return ((Constant)o).getConstant().equals(this.date);
        }
        return false;
    }
}

