/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.EConstructor;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Visitor;
import java.lang.reflect.Array;

public class EArrayConstructor<D>
extends EConstructor<D[]> {
    private static final long serialVersionUID = 8667880104290226505L;
    private final Class<D> elementType;

    public EArrayConstructor(Expr<?> ... args) {
        this(Object[].class, args);
    }

    public EArrayConstructor(Class<D[]> type, Expr<D> ... args) {
        super(type, new Class[0], args);
        this.elementType = (Class)Assert.notNull(type.getComponentType(), (String)"componentType");
    }

    public final Class<D> getElementType() {
        return this.elementType;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public D[] newInstance(Object ... args) {
        if (args.getClass().getComponentType().equals(this.elementType)) {
            return args;
        }
        Object[] rv = (Object[])Array.newInstance(this.elementType, args.length);
        System.arraycopy(args, 0, rv, 0, args.length);
        return rv;
    }
}

