/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Expr;
import com.mysema.query.types.ExprException;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.ESimple;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ClassUtils;

public class EConstructor<D>
extends ESimple<D> {
    private static final long serialVersionUID = -602747921848073175L;
    private final List<Expr<?>> args;
    private final Class<?>[] parameterTypes;

    private static Class<?> normalize(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return ClassUtils.primitiveToWrapper(clazz);
        }
        return clazz;
    }

    public static <D> EConstructor<D> create(Class<D> type, Expr<?> ... args) {
        for (Constructor<?> c : type.getConstructors()) {
            Class<?>[] paramTypes = c.getParameterTypes();
            if (paramTypes.length != args.length) continue;
            boolean found = true;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (EConstructor.normalize(paramTypes[i]).isAssignableFrom(args[i].getType())) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return new EConstructor<D>(type, paramTypes, args);
        }
        throw new ExprException("Got no matching constructor");
    }

    public EConstructor(Class<D> type, Class<?>[] paramTypes, Expr<?> ... args) {
        super(type);
        this.parameterTypes = (Class[])paramTypes.clone();
        this.args = Collections.unmodifiableList(Arrays.asList(args));
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EConstructor) {
            EConstructor c = (EConstructor)obj;
            return Arrays.equals(this.parameterTypes, c.parameterTypes) && ((Object)this.args).equals(c.args) && this.getType().equals(c.getType());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getType().hashCode();
    }

    public final List<Expr<?>> getArgs() {
        return this.args;
    }

    public D newInstance(Object ... args) {
        try {
            return this.getType().getConstructor(this.parameterTypes).newInstance(args);
        }
        catch (SecurityException e) {
            throw new ExprException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ExprException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new ExprException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ExprException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new ExprException(e.getMessage(), e);
        }
    }
}

