/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Type;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.types.Custom;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Path;
import com.mysema.query.types.custom.CBoolean;
import com.mysema.query.types.custom.CComparable;
import com.mysema.query.types.custom.CDate;
import com.mysema.query.types.custom.CDateTime;
import com.mysema.query.types.custom.CNumber;
import com.mysema.query.types.custom.CSimple;
import com.mysema.query.types.custom.CString;
import com.mysema.query.types.custom.CTime;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EComparable;
import com.mysema.query.types.expr.EDate;
import com.mysema.query.types.expr.EDateTime;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.EString;
import com.mysema.query.types.expr.ETime;
import com.mysema.query.types.path.PBoolean;
import com.mysema.query.types.path.PComparable;
import com.mysema.query.types.path.PDate;
import com.mysema.query.types.path.PDateTime;
import com.mysema.query.types.path.PNumber;
import com.mysema.query.types.path.PSimple;
import com.mysema.query.types.path.PString;
import com.mysema.query.types.path.PTime;
import java.util.HashMap;
import java.util.Map;

public class TypeMappings {
    private final Map<TypeCategory, Class<? extends Custom>> customTypes = new HashMap<TypeCategory, Class<? extends Custom>>();
    private final Map<TypeCategory, Class<? extends Expr>> exprTypes = new HashMap<TypeCategory, Class<? extends Expr>>();
    private final Map<TypeCategory, Class<? extends Path>> pathTypes = new HashMap<TypeCategory, Class<? extends Path>>();

    public TypeMappings() {
        this.register(TypeCategory.STRING, EString.class, PString.class, CString.class);
        this.register(TypeCategory.BOOLEAN, EBoolean.class, PBoolean.class, CBoolean.class);
        this.register(TypeCategory.COMPARABLE, EComparable.class, PComparable.class, CComparable.class);
        this.register(TypeCategory.DATE, EDate.class, PDate.class, CDate.class);
        this.register(TypeCategory.DATETIME, EDateTime.class, PDateTime.class, CDateTime.class);
        this.register(TypeCategory.TIME, ETime.class, PTime.class, CTime.class);
        this.register(TypeCategory.NUMERIC, ENumber.class, PNumber.class, CNumber.class);
        this.register(TypeCategory.ARRAY, Expr.class, PSimple.class, CSimple.class);
        this.register(TypeCategory.COLLECTION, Expr.class, PSimple.class, CSimple.class);
        this.register(TypeCategory.SET, Expr.class, PSimple.class, CSimple.class);
        this.register(TypeCategory.LIST, Expr.class, PSimple.class, CSimple.class);
        this.register(TypeCategory.MAP, Expr.class, PSimple.class, CSimple.class);
        this.register(TypeCategory.SIMPLE, Expr.class, PSimple.class, CSimple.class);
        this.register(TypeCategory.ENTITY, Expr.class, Path.class, CSimple.class);
    }

    public String getCustomType(Type type, EntityType model, boolean raw) {
        return this.getCustomType(type, model, raw, false, false);
    }

    public String getCustomType(Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        return this.getQueryType(this.customTypes, type, model, raw, rawParameters, extend);
    }

    public String getExprType(Type type, EntityType model, boolean raw) {
        return this.getExprType(type, model, raw, false, false);
    }

    public String getExprType(Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        return this.getQueryType(this.exprTypes, type, model, raw, rawParameters, extend);
    }

    public String getPathType(Type type, EntityType model, boolean raw) {
        return this.getPathType(type, model, raw, false, false);
    }

    public String getPathType(Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        return this.getQueryType(this.pathTypes, type, model, raw, rawParameters, extend);
    }

    private String getQueryType(Map<TypeCategory, ? extends Class<?>> types, Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        String typeName = types.get((Object)type.getCategory()).getSimpleName();
        return this.getQueryType(type, model, typeName, raw, rawParameters, extend);
    }

    public String getQueryType(Type type, EntityType model, String typeName, boolean raw, boolean rawParameters, boolean extend) {
        String localName = null;
        TypeCategory category = type.getCategory();
        if (raw && category != TypeCategory.ENTITY) {
            return typeName;
        }
        localName = rawParameters ? type.getLocalRawName(model) : type.getLocalGenericName(model, true);
        if (!type.isFinal() && extend) {
            localName = "? extends " + localName;
        }
        if (category == TypeCategory.STRING || category == TypeCategory.BOOLEAN) {
            return typeName;
        }
        if (category == TypeCategory.ENTITY) {
            String suffix = !type.getPackageName().isEmpty() ? type.getFullName().substring(type.getPackageName().length() + 1).replace('.', '_') : type.getFullName().replace('.', '_');
            if (type.getPackageName().equals(model.getPackageName()) || type.getPackageName().isEmpty()) {
                return model.getPrefix() + suffix;
            }
            return type.getPackageName() + "." + model.getPrefix() + suffix;
        }
        return typeName + "<" + localName + ">";
    }

    private void register(TypeCategory category, Class<? extends Expr> expr, Class<? extends Path> path, Class<? extends Custom> custom) {
        this.exprTypes.put(category, expr);
        this.pathTypes.put(category, path);
        this.customTypes.put(category, custom);
    }
}

