/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.AbstractType;
import com.mysema.query.codegen.Type;
import com.mysema.query.codegen.TypeCategory;
import java.io.IOException;
import net.jcip.annotations.Immutable;

@Immutable
public final class SimpleType
extends AbstractType {
    private final String fullName;
    private final String packageName;
    private final String simpleName;
    private final String localName;
    private final Type[] parameters;
    private final TypeCategory typeCategory;
    private final boolean visible;
    private final boolean finalClass;

    public SimpleType(TypeCategory typeCategory, String name, String packageName, String simpleName, boolean finalClass, Type ... parameters) {
        this.typeCategory = (TypeCategory)((Object)Assert.notNull((Object)((Object)typeCategory), (String)"typeCategory"));
        this.fullName = (String)Assert.notNull((Object)name, (String)"name");
        this.packageName = (String)Assert.notNull((Object)packageName, (String)"packageName");
        this.simpleName = (String)Assert.notNull((Object)simpleName, (String)"simpleName");
        this.localName = !packageName.isEmpty() ? name.substring(packageName.length() + 1) : simpleName;
        this.parameters = (Type[])Assert.notNull((Object)parameters, (String)"parameters");
        this.visible = packageName.equals("java.lang");
        this.finalClass = finalClass;
    }

    @Override
    public SimpleType as(TypeCategory category) {
        if (this.typeCategory == category) {
            return this;
        }
        return new SimpleType(category, this.fullName, this.packageName, this.simpleName, this.finalClass, this.parameters);
    }

    @Override
    public Type asArrayType() {
        return new SimpleType(TypeCategory.ARRAY, this.fullName + "[]", this.packageName, this.simpleName + "[]", this.finalClass, this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Type) {
            Type t = (Type)o;
            return this.fullName.equals(t.getFullName());
        }
        return false;
    }

    @Override
    public TypeCategory getCategory() {
        return this.typeCategory;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public void appendLocalGenericName(Type context, Appendable builder, boolean asArgType) throws IOException {
        this.appendLocalRawName(context, builder);
        if (this.parameters.length > 0) {
            builder.append("<");
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                if (this.parameters[i] != null && !this.parameters[i].getFullName().equals(this.fullName)) {
                    this.parameters[i].appendLocalGenericName(context, builder, false);
                    continue;
                }
                builder.append("?");
            }
            builder.append(">");
        }
    }

    @Override
    public void appendLocalRawName(Type context, Appendable builder) throws IOException {
        if (this.visible || context.getPackageName().equals(this.packageName)) {
            builder.append(this.localName);
        } else {
            builder.append(this.fullName);
        }
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public Type getParameter(int i) {
        return this.parameters[i];
    }

    @Override
    public int getParameterCount() {
        return this.parameters.length;
    }

    @Override
    public String getPrimitiveName() {
        return null;
    }

    @Override
    public Type getSelfOrValueType() {
        if (this.typeCategory.isSubCategoryOf(TypeCategory.COLLECTION) || this.typeCategory.isSubCategoryOf(TypeCategory.MAP)) {
            return this.parameters[this.parameters.length - 1];
        }
        return this;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public boolean hasEntityFields() {
        return false;
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    @Override
    public boolean isFinal() {
        return this.finalClass;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public String toString() {
        return this.fullName;
    }
}

