/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.CodeGenerationException;
import com.mysema.query.codegen.Constructor;
import com.mysema.query.codegen.Delegate;
import com.mysema.query.codegen.Method;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.Supertype;
import com.mysema.query.codegen.Type;
import com.mysema.query.codegen.TypeAdapter;
import com.mysema.query.codegen.TypeCategory;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public final class EntityType
extends TypeAdapter
implements Comparable<EntityType> {
    private final Set<Annotation> annotations = new HashSet<Annotation>();
    private final Set<Constructor> constructors = new HashSet<Constructor>();
    private int escapeSuffix = 1;
    private boolean hasLists;
    private boolean hasMaps;
    private boolean hasEntityFields;
    private final Set<Method> methods = new HashSet<Method>();
    private final Set<Delegate> delegates = new HashSet<Delegate>();
    private final String prefix;
    private final Set<Property> properties = new TreeSet<Property>();
    private final Collection<Supertype> superTypes;
    private String uncapSimpleName;

    public EntityType(String prefix, Type type) {
        this(prefix, type, new HashSet<Supertype>());
    }

    public EntityType(String prefix, Type type, Set<Supertype> superTypes) {
        super(type);
        this.prefix = (String)Assert.notNull((Object)prefix, (String)"prefix");
        this.uncapSimpleName = StringUtils.uncapitalize((String)type.getSimpleName());
        this.superTypes = superTypes;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public void addConstructor(Constructor co) {
        this.constructors.add(co);
    }

    public void addMethod(Method method) {
        this.methods.add(method);
    }

    public void addDelegate(Delegate delegate) {
        this.delegates.add(delegate);
    }

    public void addProperty(Property field) {
        this.properties.add(this.validateField(field));
        switch (field.getType().getCategory()) {
            case MAP: {
                this.hasMaps = true;
                break;
            }
            case LIST: {
                this.hasLists = true;
                break;
            }
            case ENTITY: {
                this.hasEntityFields = true;
            }
        }
    }

    public void addSupertype(Supertype entityType) {
        this.superTypes.add(entityType);
    }

    @Override
    public int compareTo(EntityType o) {
        return this.getType().getSimpleName().compareTo(o.getType().getSimpleName());
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public TypeCategory getCategory() {
        return TypeCategory.ENTITY;
    }

    public Set<Constructor> getConstructors() {
        return this.constructors;
    }

    public String getLocalGenericName() {
        try {
            StringBuilder builder = new StringBuilder();
            this.getType().appendLocalGenericName(this, builder, false);
            return builder.toString();
        }
        catch (IOException e) {
            throw new CodeGenerationException(e.getMessage(), e);
        }
    }

    public String getLocalRawName() {
        try {
            StringBuilder builder = new StringBuilder();
            this.getType().appendLocalRawName(this, builder);
            return builder.toString();
        }
        catch (IOException e) {
            throw new CodeGenerationException(e.getMessage(), e);
        }
    }

    public Set<Method> getMethods() {
        return this.methods;
    }

    public Set<Delegate> getDelegates() {
        return this.delegates;
    }

    public TypeCategory getOriginalCategory() {
        return super.getCategory();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    @Nullable
    public Supertype getSuperType() {
        return this.superTypes.size() == 1 ? this.superTypes.iterator().next() : null;
    }

    public Collection<Supertype> getSuperTypes() {
        return this.superTypes;
    }

    public String getUncapSimpleName() {
        return this.uncapSimpleName;
    }

    @Override
    public boolean hasEntityFields() {
        return this.hasEntityFields;
    }

    public boolean hasLists() {
        return this.hasLists;
    }

    public boolean hasMaps() {
        return this.hasMaps;
    }

    public void include(Supertype supertype) {
        EntityType entityType = supertype.getEntityType();
        for (Method method : entityType.getMethods()) {
            this.addMethod(method.createCopy(this));
        }
        for (Delegate delegate : entityType.getDelegates()) {
            this.addDelegate(delegate);
        }
        for (Property property : entityType.getProperties()) {
            if (property.isInherited()) continue;
            this.addProperty(property.createCopy(this));
        }
    }

    private Property validateField(Property field) {
        if (field.getName().equals(this.uncapSimpleName)) {
            this.uncapSimpleName = StringUtils.uncapitalize((String)this.getType().getSimpleName()) + this.escapeSuffix++;
        }
        return field;
    }
}

