/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.Parameter;
import com.mysema.query.codegen.Type;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class Delegate {
    private final Type declaringType;
    private final Type delegateType;
    private final String name;
    private final List<Parameter> parameters;
    private final Type returnType;

    public Delegate(Type declaringType, Type delegateType, String name, List<Parameter> params, Type returnType) {
        this.declaringType = (Type)Assert.notNull((Object)declaringType, (String)"declaringType");
        this.delegateType = (Type)Assert.notNull((Object)delegateType, (String)"delegateType");
        this.name = (String)Assert.notNull((Object)name, (String)"name");
        this.parameters = (List)Assert.notNull(params, (String)"params");
        this.returnType = (Type)Assert.notNull((Object)returnType, (String)"returnType");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Delegate) {
            Delegate m = (Delegate)o;
            return m.name.equals(this.name) && ((Object)m.parameters).equals(this.parameters);
        }
        return false;
    }

    public Type getDeclaringType() {
        return this.declaringType;
    }

    public Type getDelegateType() {
        return this.delegateType;
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.delegateType.getFullName() + "." + this.name + " " + this.parameters;
    }
}

