/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.codegen.CodeWriter;
import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.Constructor;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Parameter;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.query.types.Expr;
import com.mysema.query.types.expr.ENumber;
import java.io.IOException;
import net.jcip.annotations.Immutable;
import org.apache.commons.collections15.Transformer;

@Immutable
public final class DTOSerializer
implements Serializer {
    private final TypeMappings typeMappings;

    public DTOSerializer(TypeMappings typeMappings) {
        this.typeMappings = (TypeMappings)Assert.notNull((Object)typeMappings, (String)"typeMappings");
    }

    protected void intro(EntityType model, CodeWriter writer) throws IOException {
        String simpleName = model.getSimpleName();
        String queryType = this.typeMappings.getPathType(model, model, false);
        String localName = model.getLocalRawName();
        if (!model.getPackageName().isEmpty()) {
            writer.packageDecl(model.getPackageName());
        }
        writer.imports(new Package[]{Expr.class.getPackage(), ENumber.class.getPackage()});
        writer.javadoc(new String[]{queryType + " is a Querydsl DTO type for " + simpleName});
        writer.beginClass(queryType, "EConstructor<" + localName + ">", new String[0]);
        writer.privateStaticFinal("long", "serialVersionUID", String.valueOf(model.hashCode()));
    }

    protected void outro(EntityType model, CodeWriter writer) throws IOException {
        writer.end();
    }

    @Override
    public void serialize(final EntityType model, SerializerConfig serializerConfig, CodeWriter writer) throws IOException {
        this.intro(model, writer);
        String localName = model.getLocalRawName();
        for (Constructor c : model.getConstructors()) {
            writer.beginConstructor(c.getParameters(), (Transformer)new Transformer<Parameter, String>(){

                public String transform(Parameter p) {
                    return DTOSerializer.this.typeMappings.getExprType(p.getType(), model, false, false, true) + " " + p.getName();
                }
            });
            writer.beginLine(new String[]{"super(" + localName + ".class"});
            writer.append((CharSequence)", new Class[]{");
            boolean first = true;
            for (Parameter p : c.getParameters()) {
                if (!first) {
                    writer.append((CharSequence)", ");
                }
                if (p.getType().getPrimitiveName() != null) {
                    writer.append((CharSequence)(p.getType().getPrimitiveName() + ".class"));
                } else {
                    p.getType().appendLocalRawName(model, (Appendable)writer);
                    writer.append((CharSequence)".class");
                }
                first = false;
            }
            writer.append((CharSequence)"}");
            for (Parameter p : c.getParameters()) {
                writer.append((CharSequence)(", " + p.getName()));
            }
            writer.append((CharSequence)");\n");
            writer.end();
        }
        this.outro(model, writer);
    }
}

