/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.AbstractType;
import com.mysema.query.codegen.Type;
import com.mysema.query.codegen.TypeCategory;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang.ClassUtils;

@Immutable
public final class ClassType
extends AbstractType {
    private final Class<?> clazz;
    private final List<Type> parameters;
    @Nullable
    private final Class<?> primitiveClass;
    private final TypeCategory typeCategory;
    private final boolean visible;

    public ClassType(TypeCategory typeCategory, Class<?> clazz, Type ... params) {
        this(typeCategory, clazz, ClassUtils.wrapperToPrimitive(clazz), params);
    }

    public ClassType(TypeCategory typeCategory, Class<?> clazz, @Nullable Class<?> primitiveClass, Type ... params) {
        this.typeCategory = (TypeCategory)((Object)Assert.notNull((Object)((Object)typeCategory), (String)"typeCategory"));
        this.clazz = (Class)Assert.notNull(clazz, (String)"clazz");
        this.primitiveClass = primitiveClass;
        this.parameters = Arrays.asList(params);
        this.visible = clazz.isArray() ? clazz.getComponentType().getPackage().getName().equals("java.lang") : clazz.getPackage().getName().equals("java.lang");
    }

    @Override
    public Type asArrayType() {
        return new ClassType(TypeCategory.ARRAY, Array.newInstance(this.clazz, 0).getClass(), this);
    }

    @Override
    public Type as(TypeCategory category) {
        if (this.typeCategory == category) {
            return this;
        }
        return new ClassType(category, this.clazz, new Type[0]);
    }

    public boolean equals(Object o) {
        if (o instanceof Type) {
            Type t = (Type)o;
            return this.clazz.getName().equals(t.getFullName());
        }
        return false;
    }

    @Override
    public TypeCategory getCategory() {
        return this.typeCategory;
    }

    @Override
    public String getFullName() {
        return this.clazz.getName();
    }

    @Override
    public void appendLocalGenericName(Type context, Appendable builder, boolean asArgType) throws IOException {
        this.appendLocalRawName(context, builder);
    }

    @Override
    public void appendLocalRawName(Type context, Appendable builder) throws IOException {
        String name;
        String packageName;
        if (this.clazz.isArray()) {
            packageName = this.clazz.getComponentType().getPackage().getName();
            name = this.clazz.getComponentType().getName();
        } else {
            packageName = this.clazz.getPackage().getName();
            name = this.clazz.getName();
        }
        if ((this.visible || context.getPackageName().equals(packageName)) && !packageName.isEmpty()) {
            builder.append(name.substring(packageName.length() + 1));
        } else {
            builder.append(name);
        }
        if (this.clazz.isArray()) {
            builder.append("[]");
        }
    }

    @Override
    public String getPackageName() {
        return this.clazz.getPackage().getName();
    }

    @Override
    public Type getParameter(int i) {
        return this.parameters.get(i);
    }

    @Override
    public int getParameterCount() {
        return this.parameters.size();
    }

    @Override
    public String getPrimitiveName() {
        return this.primitiveClass != null ? this.primitiveClass.getSimpleName() : null;
    }

    @Override
    public Type getSelfOrValueType() {
        if (this.typeCategory.isSubCategoryOf(TypeCategory.COLLECTION) || this.typeCategory.isSubCategoryOf(TypeCategory.MAP)) {
            return this.parameters.get(this.parameters.size() - 1);
        }
        return this;
    }

    @Override
    public String getSimpleName() {
        return this.clazz.getSimpleName();
    }

    @Override
    public boolean hasEntityFields() {
        return false;
    }

    public int hashCode() {
        return this.clazz.getName().hashCode();
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.clazz.getModifiers());
    }

    @Override
    public boolean isPrimitive() {
        return this.primitiveClass != null;
    }
}

