/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.alias;

import com.mysema.commons.lang.Pair;
import com.mysema.query.alias.ManagedObject;
import com.mysema.query.alias.PEntityTransformer;
import com.mysema.query.alias.PropertyAccessInvocationHandler;
import com.mysema.query.types.Expr;
import com.mysema.query.types.path.PEntity;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.map.LazyMap;

public class AliasFactory {
    private final ThreadLocal<Expr<?>> current = new ThreadLocal();
    private final Map<Pair<Class<?>, String>, PEntity<?>> pathCache = LazyMap.decorate(new HashMap(), (Transformer)new PEntityTransformer());
    private final Map<Pair<Class<?>, Expr<?>>, ManagedObject> proxyCache = LazyMap.decorate(new HashMap(), (Transformer)new Transformer<Pair<Class<?>, Expr<?>>, ManagedObject>(){

        public ManagedObject transform(Pair<Class<?>, Expr<?>> input) {
            return (ManagedObject)AliasFactory.this.createProxy((Class)input.getFirst(), (Expr)input.getSecond());
        }
    });

    public <A> A createAliasForExpr(Class<A> cl, Expr<? extends A> expr) {
        return (A)this.proxyCache.get(Pair.of(cl, expr));
    }

    public <A> A createAliasForProperty(Class<A> cl, Object parent, Expr<?> path) {
        return this.createProxy(cl, path);
    }

    public <A> A createAliasForVariable(Class<A> cl, String var) {
        Expr path = this.pathCache.get(Pair.of(cl, (Object)var));
        return (A)this.proxyCache.get(Pair.of(cl, (Object)path));
    }

    private <A> A createProxy(Class<A> cl, Expr<?> path) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(AliasFactory.class.getClassLoader());
        if (cl.isInterface()) {
            enhancer.setInterfaces(new Class[]{cl, ManagedObject.class});
        } else {
            enhancer.setSuperclass(cl);
            enhancer.setInterfaces(new Class[]{ManagedObject.class});
        }
        PropertyAccessInvocationHandler handler = new PropertyAccessInvocationHandler(path, this);
        enhancer.setCallback((Callback)handler);
        return (A)enhancer.create();
    }

    @Nullable
    public <A extends Expr<?>> A getCurrent() {
        return (A)this.current.get();
    }

    @Nullable
    public <A extends Expr<?>> A getCurrentAndReset() {
        A rv = this.getCurrent();
        this.reset();
        return rv;
    }

    public void reset() {
        this.current.set(null);
    }

    public void setCurrent(Expr<?> path) {
        this.current.set(path);
    }
}

