/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.alias;

import com.mysema.query.alias.AliasFactory;
import com.mysema.query.alias.ManagedObject;
import com.mysema.query.types.Expr;
import com.mysema.query.types.path.PArray;
import com.mysema.query.types.path.PBoolean;
import com.mysema.query.types.path.PCollection;
import com.mysema.query.types.path.PComparable;
import com.mysema.query.types.path.PDate;
import com.mysema.query.types.path.PDateTime;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.path.PList;
import com.mysema.query.types.path.PMap;
import com.mysema.query.types.path.PNumber;
import com.mysema.query.types.path.PSet;
import com.mysema.query.types.path.PSimple;
import com.mysema.query.types.path.PString;
import com.mysema.query.types.path.PTime;
import com.mysema.query.types.path.PathBuilder;
import com.mysema.query.types.path.PathMetadataFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public final class Alias {
    private static final AliasFactory aliasFactory = new AliasFactory();
    private static final PSimple<Object> it = new PSimple<Object>(Object.class, PathMetadataFactory.forVariable("it"));

    public static <D extends Expr<?>> D $() {
        return (D)aliasFactory.getCurrentAndReset();
    }

    public static <D> PArray<D> $(D[] arg) {
        return (PArray)aliasFactory.getCurrentAndReset();
    }

    public static PNumber<BigDecimal> $(BigDecimal arg) {
        return (PNumber)aliasFactory.getCurrentAndReset();
    }

    public static PNumber<BigInteger> $(BigInteger arg) {
        return (PNumber)aliasFactory.getCurrentAndReset();
    }

    public static PBoolean $(Boolean arg) {
        return (PBoolean)aliasFactory.getCurrentAndReset();
    }

    public static PNumber<Byte> $(Byte arg) {
        return (PNumber)aliasFactory.getCurrentAndReset();
    }

    public static <D> PCollection<D> $(Collection<D> args) {
        return (PCollection)aliasFactory.getCurrentAndReset();
    }

    public static <D extends Comparable<?>> PComparable<D> $(D arg) {
        return (PComparable)aliasFactory.getCurrentAndReset();
    }

    @Nullable
    public static <D> PEntity<D> $(D arg) {
        PEntity rv = (PEntity)aliasFactory.getCurrentAndReset();
        if (rv != null) {
            return rv;
        }
        if (arg instanceof ManagedObject) {
            return ((ManagedObject)arg).__mappedPath();
        }
        return null;
    }

    public static PNumber<Double> $(Double arg) {
        return (PNumber)aliasFactory.getCurrentAndReset();
    }

    public static PNumber<Float> $(Float arg) {
        return (PNumber)aliasFactory.getCurrentAndReset();
    }

    public static PNumber<Integer> $(Integer arg) {
        return (PNumber)aliasFactory.getCurrentAndReset();
    }

    public static PDate<Date> $(Date arg) {
        return (PDate)aliasFactory.getCurrentAndReset();
    }

    public static PDateTime<java.util.Date> $(java.util.Date arg) {
        return (PDateTime)aliasFactory.getCurrentAndReset();
    }

    public static <D> PList<D, ?> $(List<D> args) {
        return (PList)aliasFactory.getCurrentAndReset();
    }

    public static PNumber<Long> $(Long arg) {
        return (PNumber)aliasFactory.getCurrentAndReset();
    }

    public static <K, V> PMap<K, V, ?> $(Map<K, V> args) {
        return (PMap)aliasFactory.getCurrentAndReset();
    }

    public static <D> PSet<D> $(Set<D> args) {
        return (PSet)aliasFactory.getCurrentAndReset();
    }

    public static PNumber<Short> $(Short arg) {
        return (PNumber)aliasFactory.getCurrentAndReset();
    }

    public static PString $(String arg) {
        return (PString)aliasFactory.getCurrentAndReset();
    }

    public static PTime<Time> $(Time arg) {
        return (PTime)aliasFactory.getCurrentAndReset();
    }

    public static PDateTime<Timestamp> $(Timestamp arg) {
        return (PDateTime)aliasFactory.getCurrentAndReset();
    }

    public static <A> A alias(Class<A> cl) {
        return Alias.alias(cl, StringUtils.uncapitalize((String)cl.getSimpleName()));
    }

    public static <A> A alias(Class<A> cl, Expr<? extends A> expr) {
        return aliasFactory.createAliasForExpr(cl, expr);
    }

    public static <A> A alias(Class<A> cl, String var) {
        return aliasFactory.createAliasForVariable(cl, var);
    }

    public static <D> Expr<D> getAny(D arg) {
        Object current = aliasFactory.getCurrentAndReset();
        if (current != null) {
            return current;
        }
        if (arg instanceof ManagedObject) {
            return ((ManagedObject)arg).__mappedPath();
        }
        throw new IllegalArgumentException("No path mapped to " + arg);
    }

    public static void resetAlias() {
        aliasFactory.reset();
    }

    public static <D> PSimple<D> var() {
        return it;
    }

    public static <D extends Comparable<?>> PComparable<D> var(D arg) {
        return new PComparable(arg.getClass(), "var" + arg);
    }

    public static <D extends Number> PNumber<D> var(D arg) {
        return new PNumber(arg.getClass(), "var" + arg.getClass().getSimpleName() + arg);
    }

    public static <D> PEntity<D> var(D arg) {
        String var = "var" + arg.getClass().getSimpleName() + "_" + arg.toString().replace(' ', '_');
        return new PathBuilder(arg.getClass(), var);
    }

    public static PString var(String arg) {
        return new PString(arg.replace(' ', '_'));
    }

    private Alias() {
    }
}

