/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.util.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.util.codegen.CodeWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.lang.StringEscapeUtils;

public final class JavaWriter
implements Appendable,
CodeWriter {
    private static final String EXTENDS = " extends ";
    private static final String IMPLEMENTS = " implements ";
    private static final String IMPORT = "import ";
    private static final String IMPORT_STATIC = "import static ";
    private static final String JAVA_LANG = "java.lang";
    private static final String PACKAGE = "package ";
    private static final String PRIVATE_STATIC_FINAL = "private static final ";
    private static final String PROTECTED = "protected ";
    private static final String PUBLIC = "public ";
    private static final String PUBLIC_CLASS = "public class ";
    private static final String PUBLIC_FINAL = "public final ";
    private static final String PUBLIC_INTERFACE = "public interface ";
    private static final String PUBLIC_STATIC = "public static ";
    private static final String PUBLIC_STATIC_FINAL = "public static final ";
    private final Appendable appendable;
    private String indent = "";
    private String type;

    public JavaWriter(Appendable appendable) {
        this.appendable = (Appendable)Assert.notNull((Object)appendable, (String)"appendable");
    }

    @Override
    public CodeWriter annotation(Annotation annotation) throws IOException {
        this.append(this.indent).append("@" + annotation.annotationType().getName()).append("(");
        boolean first = true;
        for (Method method : annotation.annotationType().getDeclaredMethods()) {
            if (!first) {
                this.append(", ");
            }
            this.append(method.getName() + "=");
            try {
                Object value = method.invoke((Object)annotation, new Object[0]);
                this.annotationConstant(value);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            first = false;
        }
        return this.append(")").nl();
    }

    private void annotationConstant(Object value) throws IOException {
        if (value instanceof Class) {
            Class clazz = (Class)value;
            if (!clazz.getPackage().getName().equals(JAVA_LANG)) {
                this.append(clazz.getName() + ".class");
            } else {
                this.append(clazz.getSimpleName() + ".class");
            }
        } else if (value instanceof Number) {
            this.append(value.toString());
        } else if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            this.append(enumValue.getDeclaringClass().getName() + "." + enumValue.name());
        } else if (value instanceof String) {
            this.append("\"" + StringEscapeUtils.escapeJava((String)value.toString()) + "\"");
        } else {
            throw new IllegalArgumentException("Unsupported annotation value : " + value);
        }
    }

    @Override
    public JavaWriter append(char c) throws IOException {
        this.appendable.append(c);
        return this;
    }

    @Override
    public JavaWriter append(CharSequence csq) throws IOException {
        this.appendable.append(csq);
        return this;
    }

    @Override
    public JavaWriter append(CharSequence csq, int start, int end) throws IOException {
        this.appendable.append(csq, start, end);
        return this;
    }

    @Override
    public CodeWriter beginClass(String simpleName, String superClass, String ... interfaces) throws IOException {
        this.append(this.indent + PUBLIC_CLASS + simpleName);
        if (superClass != null) {
            this.append(EXTENDS + superClass);
        }
        if (interfaces.length > 0) {
            this.append(IMPLEMENTS).join(", ", interfaces);
        }
        this.append(" {\n\n");
        this.goIn();
        this.type = simpleName;
        if (this.type.contains("<")) {
            this.type = this.type.substring(0, this.type.indexOf(60));
        }
        return this;
    }

    @Override
    public <T> CodeWriter beginConstructor(Collection<T> parameters, Transformer<T, String> transformer) throws IOException {
        this.append(this.indent + PUBLIC + this.type).params(parameters, transformer).append(" {\n");
        return this.goIn();
    }

    @Override
    public CodeWriter beginConstructor(String ... parameters) throws IOException {
        this.append(this.indent + PUBLIC + this.type).params(parameters).append(" {\n");
        return this.goIn();
    }

    @Override
    public CodeWriter beginInterface(String simpleName, String ... interfaces) throws IOException {
        this.append(this.indent + PUBLIC_INTERFACE + simpleName);
        if (interfaces.length > 0) {
            this.append(EXTENDS).join(", ", interfaces);
        }
        this.append(" {\n\n");
        this.goIn();
        this.type = simpleName;
        if (this.type.contains("<")) {
            this.type = this.type.substring(0, this.type.indexOf(60));
        }
        return this;
    }

    @Override
    public CodeWriter beginLine(String ... segments) throws IOException {
        this.append(this.indent);
        for (String segment : segments) {
            this.append(segment);
        }
        return this;
    }

    @Override
    public <T> CodeWriter beginMethod(String returnType, String methodName, Collection<T> parameters, Transformer<T, String> transformer) throws IOException {
        this.append(this.indent + PUBLIC + returnType + " " + methodName).params(parameters, transformer).append(" {\n");
        return this.goIn();
    }

    @Override
    public CodeWriter beginMethod(String returnType, String methodName, String ... args) throws IOException {
        this.append(this.indent + PUBLIC + returnType + " " + methodName).params(args).append(" {\n");
        return this.goIn();
    }

    @Override
    public <T> CodeWriter beginStaticMethod(String returnType, String methodName, Collection<T> parameters, Transformer<T, String> transformer) throws IOException {
        this.append(this.indent + PUBLIC_STATIC + returnType + " " + methodName).params(parameters, transformer).append(" {\n");
        return this.goIn();
    }

    @Override
    public CodeWriter beginStaticMethod(String returnType, String methodName, String ... args) throws IOException {
        this.append(this.indent + PUBLIC_STATIC + returnType + " " + methodName).params(args).append(" {\n");
        return this.goIn();
    }

    @Override
    public CodeWriter end() throws IOException {
        this.goOut();
        return this.line("}\n");
    }

    private CodeWriter goIn() {
        this.indent = this.indent + "    ";
        return this;
    }

    private CodeWriter goOut() {
        if (this.indent.length() >= 4) {
            this.indent = this.indent.substring(0, this.indent.length() - 4);
        }
        return this;
    }

    @Override
    public CodeWriter imports(Class<?> ... imports) throws IOException {
        for (Class<?> cl : imports) {
            this.line(IMPORT + cl.getName() + ";");
        }
        return this;
    }

    @Override
    public CodeWriter imports(Package ... imports) throws IOException {
        for (Package p : imports) {
            this.line(IMPORT + p.getName() + ".*;");
        }
        return this;
    }

    @Override
    public CodeWriter javadoc(String ... lines) throws IOException {
        this.line("/**");
        for (String line : lines) {
            this.line(" * " + line);
        }
        return this.line(" */");
    }

    @Override
    public String join(String prefix, String suffix, Iterable<String> args) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String arg : args) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(prefix).append(arg).append(suffix);
            first = false;
        }
        return builder.toString();
    }

    @Override
    public String join(String prefix, String suffix, String ... args) {
        return this.join(prefix, suffix, Arrays.asList(args));
    }

    @Override
    public CodeWriter line(String ... segments) throws IOException {
        this.append(this.indent);
        for (String segment : segments) {
            this.append(segment);
        }
        return this.append("\n");
    }

    @Override
    public CodeWriter nl() throws IOException {
        return this.append("\n");
    }

    @Override
    public CodeWriter packageDecl(String packageName) throws IOException {
        return this.line(PACKAGE + packageName + ";").nl();
    }

    private <T> CodeWriter params(Collection<T> parameters, Transformer<T, String> transformer) throws IOException {
        this.append("(");
        boolean first = true;
        for (T param : parameters) {
            if (!first) {
                this.append(", ");
            }
            this.append((CharSequence)transformer.transform(param));
            first = false;
        }
        this.append(")");
        return this;
    }

    private JavaWriter params(String ... params) throws IOException {
        this.append("(");
        this.join(", ", params);
        this.append(")");
        return this;
    }

    private JavaWriter join(String sep, String ... args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                this.append(sep);
            }
            this.append(args[i]);
        }
        return this;
    }

    @Override
    public CodeWriter privateStaticFinal(String type, String name, String value) throws IOException {
        return this.stmt(PRIVATE_STATIC_FINAL + type + " " + name + " = " + value).nl();
    }

    @Override
    public CodeWriter protectedField(String type, String name) throws IOException {
        return this.stmt(PROTECTED + type + " " + name).nl();
    }

    @Override
    public CodeWriter publicFinal(String type, String name) throws IOException {
        return this.stmt(PUBLIC_FINAL + type + " " + name).nl();
    }

    @Override
    public CodeWriter publicFinal(String type, String name, String value) throws IOException {
        return this.stmt(PUBLIC_FINAL + type + " " + name + " = " + value).nl();
    }

    @Override
    public CodeWriter publicStaticFinal(String type, String name, String value) throws IOException {
        return this.stmt(PUBLIC_STATIC_FINAL + type + " " + name + " = " + value).nl();
    }

    @Override
    public CodeWriter staticimports(Class<?> ... imports) throws IOException {
        for (Class<?> cl : imports) {
            this.line(IMPORT_STATIC + cl.getName() + ".*;");
        }
        return this;
    }

    private CodeWriter stmt(String stmt) throws IOException {
        return this.line(stmt + ";");
    }

    @Override
    public CodeWriter suppressWarnings(String type) throws IOException {
        return this.line("@SuppressWarnings(\"" + type + "\")");
    }
}

