/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.util;

import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.ClassUtils;

public final class JDBCUtil {
    private JDBCUtil() {
    }

    public static void setParameters(PreparedStatement stmt, Collection<Object> objects) {
        int counter = 1;
        for (Object o : objects) {
            try {
                JDBCUtil.setParameter(stmt, counter++, o);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static void setParameter(PreparedStatement stmt, int i, Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class type = o.getClass();
        String methodName = "set" + type.getSimpleName();
        if (methodName.equals("setInteger")) {
            methodName = "setInt";
        } else if (methodName.equals("setCharacter")) {
            methodName = "setString";
            type = String.class;
            o = o.toString();
        } else if (methodName.equals("setDate") && type.equals(Date.class)) {
            type = java.sql.Date.class;
            o = new java.sql.Date(((Date)o).getTime());
        }
        type = ClassUtils.wrapperToPrimitive(type) != null ? ClassUtils.wrapperToPrimitive(type) : type;
        PreparedStatement.class.getMethod(methodName, Integer.TYPE, type).invoke((Object)stmt, i, o);
    }
}

