/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.util;

import com.mysema.query.QueryException;
import com.mysema.util.Evaluator;
import com.mysema.util.SimpleCompiler;
import com.mysema.util.StringJavaFileObject;
import com.mysema.util.codegen.JavaWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.tools.JavaCompiler;

public class EvaluatorFactory {
    private final File classDir;
    private final ClassLoader loader;
    private final String classpath;
    private final JavaCompiler compiler;
    private final List<String> compilationOptions;

    public EvaluatorFactory(JavaCompiler compiler, File classDir, URLClassLoader parent) {
        try {
            this.compiler = compiler;
            this.classDir = classDir;
            this.classDir.mkdirs();
            this.classpath = SimpleCompiler.getClassPath(parent);
            this.loader = new URLClassLoader(new URL[]{classDir.toURI().toURL()}, (ClassLoader)parent);
            this.compilationOptions = Arrays.asList("-classpath", this.classpath, "-d", classDir.getAbsolutePath(), "-g:none");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void compile(String source, Class<?> projectionType, String[] names, Class<?>[] types, String id) throws IOException, UnsupportedEncodingException {
        StringWriter writer = new StringWriter();
        JavaWriter javaw = new JavaWriter(writer);
        javaw.beginClass(id, null, new String[0]);
        String[] params = new String[names.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.toName(types[i]) + " " + names[i];
        }
        javaw.beginStaticMethod(this.toName(projectionType), "eval", params);
        javaw.line("return ", source, ";");
        javaw.end();
        javaw.end();
        try {
            StringJavaFileObject javaFileObject = new StringJavaFileObject(id, writer.toString());
            StringWriter out = new StringWriter();
            JavaCompiler.CompilationTask task = this.compiler.getTask(out, null, null, this.compilationOptions, null, Collections.singletonList(javaFileObject));
            if (!task.call().booleanValue()) {
                throw new QueryException("Compilation of " + source + " failed.\n" + ((Object)out).toString());
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    protected String toId(String source, Class<?> returnType, Class<?> ... types) {
        StringBuilder b = new StringBuilder("Q");
        b.append("_").append(source.hashCode());
        b.append("_").append(returnType.getName().hashCode());
        for (Class<?> type : types) {
            b.append("_").append(type.getName().hashCode());
        }
        return b.toString().replace('-', '0');
    }

    protected String toName(Class<?> cl) {
        if (cl.isArray()) {
            return this.toName(cl.getComponentType()) + "[]";
        }
        if (cl.getPackage() == null || cl.getPackage().getName().equals("java.lang")) {
            return cl.getSimpleName();
        }
        return cl.getName().replace('$', '.');
    }

    public <T> Evaluator<T> createEvaluator(String source, Class<? extends T> projectionType, String[] names, Class<?>[] types) {
        try {
            String id = this.toId(source, projectionType, types);
            if (!new File(this.classDir, id + ".class").exists()) {
                this.compile(source, projectionType, names, types, id);
            }
            Class<?> clazz = this.loader.loadClass(id);
            final Method method = clazz.getMethod("eval", types);
            return new Evaluator<T>(){

                @Override
                public T evaluate(Object ... args) {
                    try {
                        return method.invoke(null, args);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalArgumentException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            };
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

