/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.query.types.Expr;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathType;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.OBoolean;
import com.mysema.util.ReflectionUtils;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import javax.annotation.Nullable;

public final class PathMixin<T>
implements Path<T>,
Serializable {
    private static final long serialVersionUID = -2498447742798348162L;
    @Nullable
    private volatile EBoolean isnull;
    @Nullable
    private volatile EBoolean isnotnull;
    private final PathMetadata<?> metadata;
    private final Path<?> root;
    private final Expr<T> self;
    @Nullable
    private AnnotatedElement annotatedElement;

    public PathMixin(Path<T> self, PathMetadata<?> metadata) {
        this.self = self.asExpr();
        this.metadata = metadata;
        this.root = metadata.getRoot() != null ? metadata.getRoot() : self;
    }

    @Override
    public Expr<T> asExpr() {
        return this.self;
    }

    public boolean equals(Object o) {
        if (o == this || o == this.self) {
            return true;
        }
        if (o instanceof Path) {
            return ((Path)o).getMetadata().equals(this.metadata);
        }
        return false;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.metadata;
    }

    @Override
    public Path<?> getRoot() {
        return this.root;
    }

    @Override
    public Class<? extends T> getType() {
        return this.self.getType();
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }

    @Override
    public EBoolean isNotNull() {
        if (this.isnotnull == null) {
            this.isnotnull = OBoolean.create(Ops.IS_NOT_NULL, this.self);
        }
        return this.isnotnull;
    }

    @Override
    public EBoolean isNull() {
        if (this.isnull == null) {
            this.isnull = OBoolean.create(Ops.IS_NULL, this.self);
        }
        return this.isnull;
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        if (this.annotatedElement == null) {
            if (this.metadata.getPathType() == PathType.PROPERTY) {
                Class<?> beanClass = this.metadata.getParent().getType();
                String propertyName = this.metadata.getExpression().toString();
                this.annotatedElement = ReflectionUtils.getAnnotatedElement(beanClass, propertyName, this.self.getType());
            } else {
                this.annotatedElement = this.self.getType();
            }
        }
        return this.annotatedElement;
    }
}

