/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Expr;
import com.mysema.query.types.ExprException;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ECollectionBase;
import com.mysema.query.types.expr.EList;
import com.mysema.query.types.path.PComparable;
import com.mysema.query.types.path.PDate;
import com.mysema.query.types.path.PDateTime;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.path.PNumber;
import com.mysema.query.types.path.PSimple;
import com.mysema.query.types.path.PTime;
import com.mysema.query.types.path.PathBuilder;
import com.mysema.query.types.path.PathMetadataFactory;
import com.mysema.query.types.path.PathMixin;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class PList<E, Q extends Expr<E>>
extends ECollectionBase<List<E>, E>
implements EList<E>,
Path<List<E>> {
    private static final long serialVersionUID = 3302301599074388860L;
    private static final Set<Class<?>> typedClasses = new HashSet<Class>(Arrays.asList(PathBuilder.class, PComparable.class, PDate.class, PDateTime.class, PEntity.class, PNumber.class, PSimple.class, PTime.class));
    private final Map<Integer, Q> cache = new HashMap<Integer, Q>();
    private final Class<E> elementType;
    private final Path<List<E>> pathMixin;
    private final Class<Q> queryType;
    @Nullable
    private transient Constructor<Q> constructor;

    public PList(Class<? super E> elementType, Class<Q> queryType, PathMetadata<?> metadata) {
        super(List.class);
        this.elementType = (Class)Assert.notNull(elementType, (String)"type is null");
        this.queryType = queryType;
        this.pathMixin = new PathMixin<List<E>>(this, metadata);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    protected PathMetadata<Integer> forListAccess(int index) {
        return PathMetadataFactory.forListAccess(this, index);
    }

    protected PathMetadata<Integer> forListAccess(Expr<Integer> index) {
        return PathMetadataFactory.forListAccess(this, index);
    }

    private Q create(int index) {
        try {
            PathMetadata<Integer> md = this.forListAccess(index);
            return this.newInstance(md);
        }
        catch (NoSuchMethodException e) {
            throw new ExprException(e);
        }
        catch (InstantiationException e) {
            throw new ExprException(e);
        }
        catch (IllegalAccessException e) {
            throw new ExprException(e);
        }
        catch (InvocationTargetException e) {
            throw new ExprException(e);
        }
    }

    @Override
    public boolean equals(Object o) {
        return this.pathMixin.equals(o);
    }

    public Q get(Expr<Integer> index) {
        try {
            PathMetadata<Integer> md = this.forListAccess(index);
            return this.newInstance(md);
        }
        catch (NoSuchMethodException e) {
            throw new ExprException(e);
        }
        catch (InstantiationException e) {
            throw new ExprException(e);
        }
        catch (IllegalAccessException e) {
            throw new ExprException(e);
        }
        catch (InvocationTargetException e) {
            throw new ExprException(e);
        }
    }

    public Q get(int index) {
        if (this.cache.containsKey(index)) {
            return (Q)((Expr)this.cache.get(index));
        }
        Q rv = this.create(index);
        this.cache.put(index, rv);
        return rv;
    }

    @Override
    public Class<E> getElementType() {
        return this.elementType;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.pathMixin.getMetadata();
    }

    @Override
    public Path<?> getRoot() {
        return this.pathMixin.getRoot();
    }

    @Override
    public int hashCode() {
        return this.pathMixin.hashCode();
    }

    @Override
    public EBoolean isNotNull() {
        return this.pathMixin.isNotNull();
    }

    @Override
    public EBoolean isNull() {
        return this.pathMixin.isNull();
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.pathMixin.getAnnotatedElement();
    }

    private Q newInstance(PathMetadata<?> pm) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.constructor == null) {
            this.constructor = typedClasses.contains(this.queryType) ? this.queryType.getConstructor(Class.class, PathMetadata.class) : this.queryType.getConstructor(PathMetadata.class);
        }
        if (typedClasses.contains(this.queryType)) {
            return (Q)((Expr)this.constructor.newInstance(this.getElementType(), pm));
        }
        return (Q)((Expr)this.constructor.newInstance(pm));
    }
}

