/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EArray;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ESimple;
import com.mysema.query.types.expr.ONumber;
import com.mysema.query.types.path.PSimple;
import com.mysema.query.types.path.PathMetadataFactory;
import com.mysema.query.types.path.PathMixin;
import java.lang.reflect.AnnotatedElement;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public class PArray<E>
extends ESimple<E[]>
implements Path<E[]>,
EArray<E> {
    private static final long serialVersionUID = 7795049264874048226L;
    private final Class<E> componentType;
    private final Path<E[]> pathMixin;
    @Nullable
    private volatile ENumber<Integer> size;

    public PArray(Class<? super E[]> type, PathMetadata<?> metadata) {
        super(type);
        this.pathMixin = new PathMixin<E[]>(this, metadata);
        this.componentType = (Class)Assert.notNull(type.getComponentType(), (String)"componentType");
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        return this.pathMixin.equals(o);
    }

    @Override
    public PSimple<E> get(Expr<Integer> index) {
        PathMetadata<Integer> md = PathMetadataFactory.forArrayAccess(this, index);
        return new PSimple<E>(this.componentType, md);
    }

    @Override
    public PSimple<E> get(@Nonnegative int index) {
        PathMetadata<Integer> md = PathMetadataFactory.forArrayAccess(this, index);
        return new PSimple<E>(this.componentType, md);
    }

    public Class<E> getElementType() {
        return this.componentType;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.pathMixin.getMetadata();
    }

    @Override
    public Path<?> getRoot() {
        return this.pathMixin.getRoot();
    }

    @Override
    public int hashCode() {
        return this.pathMixin.hashCode();
    }

    @Override
    public EBoolean isNotNull() {
        return this.pathMixin.isNotNull();
    }

    @Override
    public EBoolean isNull() {
        return this.pathMixin.isNull();
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.pathMixin.getAnnotatedElement();
    }

    @Override
    public ENumber<Integer> size() {
        if (this.size == null) {
            this.size = ONumber.create(Integer.class, Ops.ARRAY_SIZE, this);
        }
        return this.size;
    }
}

