/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Expr;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Operator;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public final class OperationMixin<RT>
implements Operation<RT>,
Serializable {
    private static final long serialVersionUID = 4796432056083507588L;
    private final List<Expr<?>> args;
    private final Operator<? super RT> operator;
    private final Expr<RT> self;

    public OperationMixin(Operation<RT> self, Operator<? super RT> operator, List<Expr<?>> args) {
        this.self = self.asExpr();
        this.operator = operator;
        this.args = Collections.unmodifiableList(args);
    }

    @Override
    public Expr<RT> asExpr() {
        return this.self;
    }

    @Override
    public Expr<?> getArg(int i) {
        return this.args.get(i);
    }

    @Override
    public List<Expr<?>> getArgs() {
        return this.args;
    }

    @Override
    public Operator<? super RT> getOperator() {
        return this.operator;
    }

    @Override
    public Class<? extends RT> getType() {
        return this.self.getType();
    }

    public boolean equals(Object o) {
        if (o == this || o == this.self) {
            return true;
        }
        if (o instanceof Operation) {
            Operation op = (Operation)o;
            return op.getOperator().equals(this.operator) && ((Object)op.getArgs()).equals(this.args) && op.getType().equals(this.self.getType());
        }
        return false;
    }

    public int hashCode() {
        return this.self.getType().hashCode();
    }
}

