/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Constant;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EBooleanConst;
import com.mysema.query.types.expr.ESimple;

public class ExprConst<D>
extends ESimple<D>
implements Constant<D> {
    private static final long serialVersionUID = -3211963259241932307L;
    private final D constant;

    public static <T> Expr<T> create(T val) {
        if (val instanceof Boolean) {
            return EBooleanConst.create((Boolean)val);
        }
        return new ExprConst<Object>(Assert.notNull(val, (String)"val is null"));
    }

    ExprConst(D constant) {
        super(constant.getClass());
        this.constant = constant;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public EBoolean eq(D s) {
        return EBooleanConst.create(this.constant.equals(s));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Constant) {
            return ((Constant)o).getConstant().equals(this.constant);
        }
        return false;
    }

    @Override
    public D getConstant() {
        return this.constant;
    }

    @Override
    public int hashCode() {
        return this.constant.hashCode();
    }

    @Override
    public EBoolean ne(D s) {
        return EBooleanConst.create(!this.constant.equals(s));
    }
}

