/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Constant;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ENumberConst;
import com.mysema.query.types.expr.ETime;
import java.util.Calendar;
import java.util.Date;

public final class ETimeConst<D extends Date>
extends ETime<D>
implements Constant<D> {
    private static final long serialVersionUID = -7835941761930555480L;
    private final Calendar calendar = Calendar.getInstance();
    private final D time;

    public static <D extends Date> ETime<D> create(D time) {
        return new ETimeConst<D>(time);
    }

    public ETimeConst(D time) {
        super(time.getClass());
        this.time = (Date)((Date)time).clone();
        this.calendar.setTime((Date)time);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public ENumber<Integer> hour() {
        return ENumberConst.create(this.calendar.get(11));
    }

    @Override
    public ENumber<Integer> minute() {
        return ENumberConst.create(this.calendar.get(12));
    }

    @Override
    public ENumber<Integer> second() {
        return ENumberConst.create(this.calendar.get(13));
    }

    @Override
    public ENumber<Integer> milliSecond() {
        return ENumberConst.create(this.calendar.get(14));
    }

    @Override
    public D getConstant() {
        return this.time;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Constant) {
            return ((Constant)o).getConstant().equals(this.time);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Date)this.time).hashCode();
    }
}

