/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Expr;
import com.mysema.query.types.Ops;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EComparable;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ENumberConst;
import com.mysema.query.types.expr.EStringConst;
import com.mysema.query.types.expr.OBoolean;
import com.mysema.query.types.expr.OComparable;
import com.mysema.query.types.expr.ONumber;
import com.mysema.query.types.expr.OSimple;
import com.mysema.query.types.expr.OString;
import javax.annotation.Nullable;

public abstract class EString
extends EComparable<String> {
    private static final long serialVersionUID = 1536955079961023361L;
    @Nullable
    private volatile ENumber<Long> length;
    @Nullable
    private volatile EString lower;
    @Nullable
    private volatile EString trim;
    @Nullable
    private volatile EString upper;
    @Nullable
    private volatile EBoolean isempty;

    public EString() {
        super(String.class);
    }

    public EString append(Expr<String> str) {
        return OString.create(Ops.CONCAT, this, str);
    }

    public EString append(String str) {
        return this.append(EStringConst.create(str));
    }

    public Expr<Character> charAt(Expr<Integer> i) {
        return OComparable.create(Character.class, Ops.CHAR_AT, this, i);
    }

    public Expr<Character> charAt(int i) {
        return this.charAt(ENumberConst.create(i));
    }

    public EString concat(Expr<String> str) {
        return this.append(str);
    }

    public EString concat(String str) {
        return this.append(str);
    }

    public EBoolean contains(Expr<String> str) {
        return OBoolean.create(Ops.STRING_CONTAINS, this, str);
    }

    public EBoolean contains(String str) {
        return this.contains(EStringConst.create(str));
    }

    public EBoolean contains(Expr<String> str, boolean caseSensitive) {
        if (caseSensitive) {
            return this.contains(str);
        }
        return OBoolean.create(Ops.STRING_CONTAINS_IC, this, str);
    }

    public EBoolean contains(String str, boolean caseSensitive) {
        return this.contains(EStringConst.create(str), caseSensitive);
    }

    public EBoolean endsWith(Expr<String> str) {
        return OBoolean.create(Ops.ENDS_WITH, this, str);
    }

    public EBoolean endsWith(Expr<String> str, boolean caseSensitive) {
        if (caseSensitive) {
            return this.endsWith(str);
        }
        return OBoolean.create(Ops.ENDS_WITH_IC, this, str);
    }

    public EBoolean endsWith(String str) {
        return this.endsWith(EStringConst.create(str));
    }

    public EBoolean endsWith(String str, boolean caseSensitive) {
        return this.endsWith(EStringConst.create(str), caseSensitive);
    }

    public EBoolean equalsIgnoreCase(Expr<String> str) {
        return OBoolean.create(Ops.EQ_IGNORE_CASE, this, str);
    }

    public EBoolean equalsIgnoreCase(String str) {
        return this.equalsIgnoreCase(EStringConst.create(str));
    }

    public ENumber<Integer> indexOf(Expr<String> str) {
        return ONumber.create(Integer.class, Ops.INDEX_OF, this, str);
    }

    public ENumber<Integer> indexOf(String str) {
        return this.indexOf(EStringConst.create(str));
    }

    public ENumber<Integer> indexOf(String str, int i) {
        return this.indexOf(EStringConst.create(str), i);
    }

    public ENumber<Integer> indexOf(Expr<String> str, int i) {
        return ONumber.create(Integer.class, Ops.INDEX_OF_2ARGS, this, str, ENumberConst.create(i));
    }

    public EBoolean isEmpty() {
        if (this.isempty == null) {
            this.isempty = OBoolean.create(Ops.STRING_IS_EMPTY, this);
        }
        return this.isempty;
    }

    public EBoolean isNotEmpty() {
        return this.isEmpty().not();
    }

    public ENumber<Long> length() {
        if (this.length == null) {
            this.length = ONumber.create(Long.class, Ops.STRING_LENGTH, this);
        }
        return this.length;
    }

    public EBoolean like(String str) {
        return OBoolean.create(Ops.LIKE, this, EStringConst.create(str));
    }

    public EBoolean like(EString str) {
        return OBoolean.create(Ops.LIKE, this, str);
    }

    public EString lower() {
        if (this.lower == null) {
            this.lower = OString.create(Ops.LOWER, this);
        }
        return this.lower;
    }

    public EBoolean matches(Expr<String> regex) {
        return OBoolean.create(Ops.MATCHES, this, regex);
    }

    public EBoolean matches(String regex) {
        return this.matches(EStringConst.create(regex));
    }

    public EString prepend(Expr<String> str) {
        return OString.create(Ops.CONCAT, str, this);
    }

    public EString prepend(String str) {
        return this.prepend(EStringConst.create(str));
    }

    public Expr<String[]> split(String regex) {
        return OSimple.create(String[].class, Ops.StringOps.SPLIT, this, EStringConst.create(regex));
    }

    public EBoolean startsWith(Expr<String> str) {
        return OBoolean.create(Ops.STARTS_WITH, this, str);
    }

    public EBoolean startsWith(Expr<String> str, boolean caseSensitive) {
        if (caseSensitive) {
            return this.startsWith(str);
        }
        return OBoolean.create(Ops.STARTS_WITH_IC, this, str);
    }

    public EBoolean startsWith(String str) {
        return this.startsWith(EStringConst.create(str));
    }

    public EBoolean startsWith(String str, boolean caseSensitive) {
        return this.startsWith(EStringConst.create(str), caseSensitive);
    }

    @Override
    public EString stringValue() {
        return this;
    }

    public EString substring(int beginIndex) {
        return OString.create(Ops.SUBSTR_1ARG, this, ENumberConst.create(beginIndex));
    }

    public EString substring(int beginIndex, int endIndex) {
        return OString.create(Ops.SUBSTR_2ARGS, this, ENumberConst.create(beginIndex), ENumberConst.create(endIndex));
    }

    public EString toLowerCase() {
        return this.lower();
    }

    public EString toUpperCase() {
        return this.upper();
    }

    public EString trim() {
        if (this.trim == null) {
            this.trim = OString.create(Ops.TRIM, this);
        }
        return this.trim;
    }

    public EString upper() {
        if (this.upper == null) {
            this.upper = OString.create(Ops.UPPER, this);
        }
        return this.upper;
    }
}

