/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Expr;
import com.mysema.query.types.Ops;
import com.mysema.query.types.expr.EDate;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ODateTime;
import com.mysema.query.types.expr.ONumber;
import java.util.Date;
import javax.annotation.Nullable;

public abstract class EDateTime<D extends Comparable>
extends EDate<D> {
    private static final EDateTime<Date> CURRENT_DATE = EDateTime.currentDate(Date.class);
    private static final EDateTime<Date> CURRENT_TIMESTAMP = EDateTime.currentTimestamp(Date.class);
    private static final long serialVersionUID = -6879277113694148047L;
    @Nullable
    private volatile ENumber<Integer> hours;
    @Nullable
    private volatile ENumber<Integer> minutes;
    @Nullable
    private volatile ENumber<Integer> seconds;
    @Nullable
    private volatile ENumber<Integer> milliseconds;
    @Nullable
    private volatile EDateTime<D> min;
    @Nullable
    private volatile EDateTime<D> max;

    public static EDateTime<Date> currentDate() {
        return CURRENT_DATE;
    }

    public static <T extends Comparable> EDateTime<T> currentDate(Class<T> cl) {
        return ODateTime.create(cl, Ops.DateTimeOps.CURRENT_DATE, new Expr[0]);
    }

    public static EDateTime<Date> currentTimestamp() {
        return CURRENT_TIMESTAMP;
    }

    public static <T extends Comparable> EDateTime<T> currentTimestamp(Class<T> cl) {
        return ODateTime.create(cl, Ops.DateTimeOps.CURRENT_TIMESTAMP, new Expr[0]);
    }

    public EDateTime(Class<? extends D> type) {
        super(type);
    }

    public ENumber<Integer> hour() {
        if (this.hours == null) {
            this.hours = ONumber.create(Integer.class, Ops.DateTimeOps.HOUR, this);
        }
        return this.hours;
    }

    @Override
    public EDateTime<D> max() {
        if (this.max == null) {
            this.max = ODateTime.create(this.getType(), Ops.AggOps.MAX_AGG, this);
        }
        return this.max;
    }

    public ENumber<Integer> milliSecond() {
        if (this.milliseconds == null) {
            this.milliseconds = ONumber.create(Integer.class, Ops.DateTimeOps.MILLISECOND, this);
        }
        return this.milliseconds;
    }

    @Override
    public EDateTime<D> min() {
        if (this.min == null) {
            this.min = ODateTime.create(this.getType(), Ops.AggOps.MIN_AGG, this);
        }
        return this.min;
    }

    public ENumber<Integer> minute() {
        if (this.minutes == null) {
            this.minutes = ONumber.create(Integer.class, Ops.DateTimeOps.MINUTE, this);
        }
        return this.minutes;
    }

    public ENumber<Integer> second() {
        if (this.seconds == null) {
            this.seconds = ONumber.create(Integer.class, Ops.DateTimeOps.SECOND, this);
        }
        return this.seconds;
    }
}

