/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Constant;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EDate;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ENumberConst;
import java.util.Calendar;
import java.util.Date;

public final class EDateConst<D extends Date>
extends EDate<D>
implements Constant<D> {
    private static final long serialVersionUID = -5745611667058255826L;
    private final D date;
    private final Calendar calendar;

    public static <D extends Date> EDate<D> create(D date) {
        return new EDateConst<D>(date);
    }

    public EDateConst(D date) {
        super(date.getClass());
        this.date = (Date)((Date)date).clone();
        this.calendar = Calendar.getInstance();
        this.calendar.setTime((Date)date);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public ENumber<Integer> dayOfMonth() {
        return ENumberConst.create(this.calendar.get(5));
    }

    @Override
    public ENumber<Integer> month() {
        return ENumberConst.create(this.calendar.get(2) + 1);
    }

    @Override
    public ENumber<Integer> year() {
        return ENumberConst.create(this.calendar.get(1));
    }

    @Override
    public ENumber<Integer> yearMonth() {
        return ENumberConst.create(this.calendar.get(1) * 100 + this.calendar.get(2) + 1);
    }

    @Override
    public ENumber<Integer> dayOfWeek() {
        return ENumberConst.create(this.calendar.get(7));
    }

    @Override
    public ENumber<Integer> dayOfYear() {
        return ENumberConst.create(this.calendar.get(6));
    }

    @Override
    public ENumber<Integer> week() {
        return ENumberConst.create(this.calendar.get(3));
    }

    @Override
    public D getConstant() {
        return this.date;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Constant) {
            return ((Constant)o).getConstant().equals(this.date);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Date)this.date).hashCode();
    }
}

