/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Expr;
import com.mysema.query.types.Ops;
import com.mysema.query.types.expr.EDateOrTime;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ODate;
import com.mysema.query.types.expr.ONumber;
import java.util.Date;
import javax.annotation.Nullable;

public abstract class EDate<D extends Comparable>
extends EDateOrTime<D> {
    private static final EDate<Date> CURRENT_DATE = EDate.currentDate(Date.class);
    private static final long serialVersionUID = 6054664454254721302L;
    @Nullable
    private volatile ENumber<Integer> dayOfMonth;
    @Nullable
    private volatile ENumber<Integer> dayOfWeek;
    @Nullable
    private volatile ENumber<Integer> dayOfYear;
    @Nullable
    private volatile EDate min;
    @Nullable
    private volatile EDate max;
    @Nullable
    private volatile ENumber<Integer> week;
    @Nullable
    private volatile ENumber<Integer> month;
    @Nullable
    private volatile ENumber<Integer> year;
    @Nullable
    private volatile ENumber<Integer> yearMonth;

    public static EDate<Date> currentDate() {
        return CURRENT_DATE;
    }

    public static <T extends Comparable> EDate<T> currentDate(Class<T> cl) {
        return ODate.create(cl, Ops.DateTimeOps.CURRENT_DATE, new Expr[0]);
    }

    public EDate(Class<? extends D> type) {
        super(type);
    }

    public ENumber<Integer> dayOfMonth() {
        if (this.dayOfMonth == null) {
            this.dayOfMonth = ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_MONTH, this);
        }
        return this.dayOfMonth;
    }

    public ENumber<Integer> dayOfWeek() {
        if (this.dayOfWeek == null) {
            this.dayOfWeek = ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_WEEK, this);
        }
        return this.dayOfWeek;
    }

    public ENumber<Integer> dayOfYear() {
        if (this.dayOfYear == null) {
            this.dayOfYear = ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_YEAR, this);
        }
        return this.dayOfYear;
    }

    public EDate<D> max() {
        if (this.max == null) {
            this.max = ODate.create(this.getType(), Ops.AggOps.MAX_AGG, this);
        }
        return this.max;
    }

    public EDate<D> min() {
        if (this.min == null) {
            this.min = ODate.create(this.getType(), Ops.AggOps.MIN_AGG, this);
        }
        return this.min;
    }

    public ENumber<Integer> month() {
        if (this.month == null) {
            this.month = ONumber.create(Integer.class, Ops.DateTimeOps.MONTH, this);
        }
        return this.month;
    }

    public ENumber<Integer> week() {
        if (this.week == null) {
            this.week = ONumber.create(Integer.class, Ops.DateTimeOps.WEEK, this);
        }
        return this.week;
    }

    public ENumber<Integer> year() {
        if (this.year == null) {
            this.year = ONumber.create(Integer.class, Ops.DateTimeOps.YEAR, this);
        }
        return this.year;
    }

    public ENumber<Integer> yearMonth() {
        if (this.yearMonth == null) {
            this.yearMonth = ONumber.create(Integer.class, Ops.DateTimeOps.YEAR_MONTH, this);
        }
        return this.yearMonth;
    }
}

