/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Expr;
import com.mysema.query.types.Ops;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ECollection;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ESimple;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.expr.OBoolean;
import com.mysema.query.types.expr.ONumber;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class ECollectionBase<C extends Collection<E>, E>
extends ESimple<C>
implements ECollection<C, E> {
    private static final long serialVersionUID = 691230660037162054L;
    @Nullable
    private volatile EBoolean empty;
    @Nullable
    private volatile ENumber<Integer> size;

    public ECollectionBase(Class<? extends C> type) {
        super(type);
    }

    @Override
    public final EBoolean contains(E child) {
        return this.contains(ExprConst.create(child));
    }

    @Override
    public final EBoolean contains(Expr<E> child) {
        return OBoolean.create(Ops.IN, child, this);
    }

    @Override
    public final EBoolean isEmpty() {
        if (this.empty == null) {
            this.empty = OBoolean.create(Ops.COL_IS_EMPTY, this);
        }
        return this.empty;
    }

    @Override
    public final EBoolean isNotEmpty() {
        return this.isEmpty().not();
    }

    @Override
    public final ENumber<Integer> size() {
        if (this.size == null) {
            this.size = ONumber.create(Integer.class, Ops.COL_SIZE, this);
        }
        return this.size;
    }
}

