/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Constant;
import com.mysema.query.types.Custom;
import com.mysema.query.types.EArrayConstructor;
import com.mysema.query.types.EConstructor;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQuery;
import com.mysema.query.types.Template;
import com.mysema.query.types.Templates;
import com.mysema.query.types.Visitor;

public final class ToStringVisitor
implements Visitor {
    private final Templates templates;
    private String toString = "?";

    public ToStringVisitor(Templates templates) {
        this.templates = templates;
    }

    public String toString() {
        return this.toString;
    }

    @Override
    public void visit(Custom<?> expr) {
        StringBuilder builder = new StringBuilder();
        for (Template.Element element : expr.getTemplate().getElements()) {
            if (element.getStaticText() != null) {
                builder.append(element.getStaticText());
                continue;
            }
            builder.append(expr.getArg(element.getIndex()));
        }
        this.toString = builder.toString();
    }

    @Override
    public void visit(EArrayConstructor<?> e) {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < e.getArgs().size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(e.getArg(i));
        }
        builder.append("]");
        this.toString = builder.toString();
    }

    @Override
    public void visit(Constant<?> e) {
        this.toString = e.getConstant().toString();
    }

    @Override
    public void visit(EConstructor<?> e) {
        StringBuilder builder = new StringBuilder();
        builder.append("new ").append(e.getType().getSimpleName()).append("(");
        for (int i = 0; i < e.getArgs().size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(e.getArg(i));
        }
        builder.append(")");
        this.toString = builder.toString();
    }

    @Override
    public void visit(Operation<?> o) {
        Template template = this.templates.getTemplate(o.getOperator());
        if (template != null) {
            StringBuilder builder = new StringBuilder();
            for (Template.Element element : template.getElements()) {
                if (element.getStaticText() != null) {
                    builder.append(element.getStaticText());
                    continue;
                }
                builder.append(o.getArg(element.getIndex()));
            }
            this.toString = builder.toString();
        } else {
            this.toString = "unknown operation with args " + o.getArgs();
        }
    }

    @Override
    public void visit(Path<?> p) {
        Path<?> parent = p.getMetadata().getParent();
        Expr<?> expr = p.getMetadata().getExpression();
        if (parent != null) {
            Template pattern = this.templates.getTemplate(p.getMetadata().getPathType());
            if (pattern != null) {
                StringBuilder builder = new StringBuilder();
                for (Template.Element element : pattern.getElements()) {
                    if (element.getStaticText() != null) {
                        builder.append(element.getStaticText());
                        continue;
                    }
                    if (element.getIndex() == 0) {
                        builder.append(parent);
                        continue;
                    }
                    if (element.getIndex() != 1) continue;
                    builder.append(expr);
                }
                this.toString = builder.toString();
            }
        } else if (expr != null) {
            this.toString = expr.toString();
        }
    }

    @Override
    public void visit(SubQuery<?> expr) {
        this.toString = expr.getMetadata().toString();
    }
}

