/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Converter;
import com.mysema.query.types.Template;
import com.mysema.query.types.expr.EString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;

@Immutable
public class TemplateFactory {
    private static final Pattern elementPattern = Pattern.compile("\\{%?\\d+[slu%]?\\}");
    public static final TemplateFactory DEFAULT = new TemplateFactory();
    private final Map<String, Template> cache = new HashMap<String, Template>();

    public Template create(String template) {
        if (this.cache.containsKey(template)) {
            return this.cache.get(template);
        }
        Matcher m = elementPattern.matcher(template);
        ArrayList<Template.Element> elements = new ArrayList<Template.Element>();
        int end = 0;
        while (m.find()) {
            if (m.start() > end) {
                elements.add(new Template.Element(template.substring(end, m.start())));
            }
            String str = template.substring(m.start() + 1, m.end() - 1).toLowerCase(Locale.ENGLISH);
            boolean asString = false;
            Converter<EString, EString> converter = null;
            if (str.charAt(0) == '%') {
                converter = Converter.toEndsWithViaLike;
                str = str.substring(1);
            }
            switch (str.charAt(str.length() - 1)) {
                case 'l': {
                    converter = Converter.toLowerCase;
                    break;
                }
                case 'u': {
                    converter = Converter.toUpperCase;
                    break;
                }
                case '%': {
                    converter = converter == null ? Converter.toStartsWithViaLike : Converter.toContainsViaLike;
                    break;
                }
                case 's': {
                    asString = true;
                }
            }
            if (asString || converter != null && converter != Converter.toEndsWithViaLike) {
                str = str.substring(0, str.length() - 1);
            }
            int index = Integer.parseInt(str);
            if (asString) {
                elements.add(new Template.Element(index, true));
            } else if (converter != null) {
                elements.add(new Template.Element(index, converter));
            } else {
                elements.add(new Template.Element(index, false));
            }
            end = m.end();
        }
        if (end < template.length()) {
            elements.add(new Template.Element(template.substring(end)));
        }
        Template rv = new Template(template, elements);
        this.cache.put(template, rv);
        return rv;
    }
}

