/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Converter;
import com.mysema.query.types.Expr;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public final class Template
implements Serializable {
    private static final long serialVersionUID = -1697705745769542204L;
    private final List<Element> elements;
    private final String template;

    Template(String template, List<Element> elements) {
        this.template = template;
        this.elements = elements;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public String toString() {
        return this.template;
    }

    @Immutable
    public static final class Element
    implements Serializable {
        private static final long serialVersionUID = -6861235060996903489L;
        private final int index;
        @Nullable
        private final String staticText;
        @Nullable
        private final transient Converter<?, ?> converter;
        private final boolean asString;
        private final String toString;

        Element(int index, Converter<?, ?> converter) {
            this.asString = false;
            this.converter = converter;
            this.index = index;
            this.staticText = null;
            this.toString = String.valueOf(index);
        }

        Element(int index, boolean asString) {
            this.asString = asString;
            this.converter = null;
            this.index = index;
            this.staticText = null;
            this.toString = index + (asString ? "s" : "");
        }

        Element(String text) {
            this.asString = false;
            this.converter = null;
            this.index = -1;
            this.staticText = text;
            this.toString = "'" + this.staticText + "'";
        }

        public int getIndex() {
            return this.index;
        }

        @Nullable
        public String getStaticText() {
            return this.staticText;
        }

        public boolean isAsString() {
            return this.asString;
        }

        public boolean hasConverter() {
            return this.converter != null;
        }

        public Expr<?> convert(Expr<?> source) {
            return this.converter.convert(source);
        }

        public String toString() {
            return this.toString;
        }
    }
}

