/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.Projectable;
import com.mysema.query.SearchResults;
import com.mysema.query.support.QueryBase;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.Expr;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.IteratorUtils;

public abstract class ProjectableQuery<Q extends ProjectableQuery<Q>>
extends QueryBase<Q>
implements Projectable {
    public ProjectableQuery(QueryMixin<Q> queryMixin) {
        super(queryMixin);
    }

    @Override
    public long countDistinct() {
        this.queryMixin.setDistinct(true);
        return this.count();
    }

    @Override
    public final CloseableIterator<Object[]> iterate(Expr<?> first, Expr<?> second, Expr<?> ... rest) {
        return this.iterate(this.merge(first, second, rest));
    }

    @Override
    public final CloseableIterator<Object[]> iterateDistinct(Expr<?> first, Expr<?> second, Expr<?> ... rest) {
        this.queryMixin.setDistinct(true);
        return this.iterate(first, second, rest);
    }

    @Override
    public final CloseableIterator<Object[]> iterateDistinct(Expr<?>[] args) {
        this.queryMixin.setDistinct(true);
        return this.iterate(args);
    }

    @Override
    public final <RT> CloseableIterator<RT> iterateDistinct(Expr<RT> projection) {
        this.queryMixin.setDistinct(true);
        return this.iterate(projection);
    }

    @Override
    public final List<Object[]> list(Expr<?> first, Expr<?> second, Expr<?> ... rest) {
        return this.list(this.merge(first, second, rest));
    }

    @Override
    public List<Object[]> list(Expr<?>[] args) {
        return IteratorUtils.toList(this.iterate(args));
    }

    @Override
    public <RT> List<RT> list(Expr<RT> projection) {
        return IteratorUtils.toList(this.iterate(projection));
    }

    @Override
    public final List<Object[]> listDistinct(Expr<?> first, Expr<?> second, Expr<?> ... rest) {
        this.queryMixin.setDistinct(true);
        return this.list(first, second, rest);
    }

    @Override
    public final List<Object[]> listDistinct(Expr<?>[] args) {
        this.queryMixin.setDistinct(true);
        return this.list(args);
    }

    @Override
    public final <RT> List<RT> listDistinct(Expr<RT> projection) {
        this.queryMixin.setDistinct(true);
        return this.list(projection);
    }

    @Override
    public final <RT> SearchResults<RT> listDistinctResults(Expr<RT> projection) {
        this.queryMixin.setDistinct(true);
        return this.listResults(projection);
    }

    @Override
    public final <K, V> Map<K, V> map(Expr<K> key, Expr<V> value) {
        List<Object[]> list = this.list(key, value, new Expr[0]);
        LinkedHashMap<Object, Object> results = new LinkedHashMap<Object, Object>(list.size());
        for (Object[] row : list) {
            results.put(row[0], row[1]);
        }
        return results;
    }

    private Expr<?>[] merge(Expr<?> first, Expr<?> second, Expr<?> ... rest) {
        Expr[] args = new Expr[rest.length + 2];
        args[0] = first;
        args[1] = second;
        System.arraycopy(rest, 0, args, 2, rest.length);
        return args;
    }

    @Override
    public final Object[] uniqueResult(Expr<?> first, Expr<?> second, Expr<?> ... rest) {
        return this.uniqueResult(this.merge(first, second, rest));
    }

    @Override
    public Object[] uniqueResult(Expr<?>[] args) {
        this.queryMixin.setUnique(true);
        CloseableIterator<Object[]> it = this.iterate(args);
        return it.hasNext() ? (Object[])it.next() : null;
    }

    @Override
    public <RT> RT uniqueResult(Expr<RT> expr) {
        this.queryMixin.setUnique(true);
        this.limit(1L);
        CloseableIterator<RT> it = this.iterate(expr);
        return it.hasNext() ? (RT)it.next() : null;
    }
}

