/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.paging;

import com.mysema.commons.lang.Assert;
import com.mysema.query.paging.ListSource;
import java.util.Arrays;
import java.util.List;

public class SimpleListSource<T>
implements ListSource<T> {
    private final List<T> list;

    public SimpleListSource(List<T> list) {
        this.list = (List)Assert.notNull(list, (String)"list");
    }

    public SimpleListSource(T ... args) {
        this(Arrays.asList(args));
    }

    @Override
    public List<T> getResults(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, Math.min(this.list.size(), toIndex));
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public long size() {
        return this.list.size();
    }
}

