/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.SimpleType;
import com.mysema.query.codegen.Supertype;
import com.mysema.query.codegen.Type;
import com.mysema.query.codegen.TypeExtends;

public final class TypeResolver {
    public static Type resolve(Type type, Type declaringType, EntityType context) {
        Type resolved = type;
        if (resolved instanceof TypeExtends) {
            resolved = TypeResolver.resolveTypeExtends((TypeExtends)resolved, declaringType, context);
        }
        if (resolved.getParameterCount() > 0) {
            resolved = TypeResolver.resolveWithParameters(resolved, declaringType, context);
        }
        return resolved;
    }

    private static Type resolveTypeExtends(TypeExtends typeExtends, Type declaringType, EntityType subtype) {
        if (typeExtends.getVarName() == null) {
            return typeExtends;
        }
        int index = -1;
        for (int i = 0; i < declaringType.getParameterCount(); ++i) {
            Type param = declaringType.getParameter(i);
            if (!(param instanceof TypeExtends) || !((TypeExtends)param).getVarName().equals(typeExtends.getVarName())) continue;
            index = i;
        }
        Supertype type = subtype.getSuperType();
        while (!type.getType().equals(declaringType)) {
            type = type.getEntityType().getSuperType();
        }
        return type.getType().getParameter(index);
    }

    private static Type resolveWithParameters(Type type, Type declaringType, EntityType context) {
        Type[] params = new Type[type.getParameterCount()];
        boolean transformed = false;
        for (int i = 0; i < type.getParameterCount(); ++i) {
            Type param = type.getParameter(i);
            if (param == null) continue;
            params[i] = TypeResolver.resolve(param, declaringType, context);
            if (params[i] == param) continue;
            transformed = true;
        }
        if (transformed) {
            return new SimpleType(type.getCategory(), type.getFullName(), type.getPackageName(), type.getSimpleName(), type.isFinal(), params);
        }
        return type;
    }

    private TypeResolver() {
    }
}

