/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.query.codegen.ClassType;
import com.mysema.query.codegen.SimpleType;
import com.mysema.query.codegen.Type;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;

public final class TypeFactory {
    private final Map<List<java.lang.reflect.Type>, Type> cache = new HashMap<List<java.lang.reflect.Type>, Type>();
    private final Collection<Class<? extends Annotation>> entityAnnotations;

    public TypeFactory(Class<?> ... entityAnnotations) {
        this.entityAnnotations = Arrays.asList(entityAnnotations);
    }

    public TypeFactory(List<Class<? extends Annotation>> entityAnnotations) {
        this.entityAnnotations = entityAnnotations;
    }

    public Type create(Class<?> cl) {
        return this.create(cl, cl);
    }

    public Type create(Class<?> cl, java.lang.reflect.Type genericType) {
        Type valueInfo;
        Type value;
        List<java.lang.reflect.Type> key = Arrays.asList(cl, genericType);
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        if (cl.isPrimitive()) {
            cl = ClassUtils.primitiveToWrapper(cl);
        }
        boolean entity = false;
        for (Class<? extends Annotation> clazz : this.entityAnnotations) {
            if (cl.getAnnotation(clazz) == null) continue;
            entity = true;
            break;
        }
        if (entity) {
            value = new ClassType(TypeCategory.ENTITY, cl, new Type[0]);
        } else if (cl.isArray()) {
            value = this.create(cl.getComponentType()).asArrayType();
        } else if (cl.isEnum()) {
            value = new ClassType(TypeCategory.SIMPLE, cl, new Type[0]);
        } else if (Map.class.isAssignableFrom(cl)) {
            Type keyInfo = this.create(ReflectionUtils.getTypeParameter(genericType, 0));
            Type valueInfo2 = this.create(ReflectionUtils.getTypeParameter(genericType, 1));
            value = this.createMapType(keyInfo, valueInfo2);
        } else if (List.class.isAssignableFrom(cl)) {
            valueInfo = this.create(ReflectionUtils.getTypeParameter(genericType, 0));
            value = this.createListType(valueInfo);
        } else if (Set.class.isAssignableFrom(cl)) {
            valueInfo = this.create(ReflectionUtils.getTypeParameter(genericType, 0));
            value = this.createSetType(valueInfo);
        } else if (Collection.class.isAssignableFrom(cl)) {
            valueInfo = this.create(ReflectionUtils.getTypeParameter(genericType, 0));
            value = this.createCollectionType(valueInfo);
        } else if (Number.class.isAssignableFrom(cl) && Comparable.class.isAssignableFrom(cl)) {
            value = new ClassType(TypeCategory.NUMERIC, cl, new Type[0]);
        } else {
            TypeCategory typeCategory = TypeCategory.get(cl.getName());
            if (!typeCategory.isSubCategoryOf(TypeCategory.COMPARABLE) && Comparable.class.isAssignableFrom(cl)) {
                typeCategory = TypeCategory.COMPARABLE;
            }
            value = new ClassType(typeCategory, cl, new Type[0]);
        }
        this.cache.put(key, value);
        return value;
    }

    public Type createCollectionType(Type valueType) {
        return this.createComposite(TypeCategory.COLLECTION, Collection.class, valueType);
    }

    private Type createComposite(TypeCategory container, Class<?> containerType, Type ... parameters) {
        return new SimpleType(container, containerType.getName(), containerType.getPackage().getName(), containerType.getSimpleName(), Modifier.isFinal(containerType.getModifiers()), parameters);
    }

    public Type createListType(Type valueType) {
        return this.createComposite(TypeCategory.LIST, List.class, valueType);
    }

    public Type createMapType(Type keyType, Type valueType) {
        return this.createComposite(TypeCategory.MAP, Map.class, keyType, valueType);
    }

    public Type createSetType(Type valueType) {
        return this.createComposite(TypeCategory.SET, Collection.class, valueType);
    }
}

