/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.Constructor;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Method;
import com.mysema.query.codegen.Parameter;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.Supertype;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.custom.CSimple;
import com.mysema.query.types.expr.EComparable;
import com.mysema.query.types.path.PComparable;
import com.mysema.query.types.path.PDate;
import com.mysema.query.types.path.PDateTime;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.path.PNumber;
import com.mysema.query.types.path.PSimple;
import com.mysema.query.types.path.PTime;
import com.mysema.query.types.path.PathMetadataFactory;
import com.mysema.util.codegen.CodeWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import net.jcip.annotations.Immutable;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.lang.StringEscapeUtils;

@Immutable
public class EntitySerializer
implements Serializer {
    private static final String PATH_METADATA = "PathMetadata<?> metadata";
    private final TypeMappings typeMappings;

    public EntitySerializer(TypeMappings mappings) {
        this.typeMappings = (TypeMappings)Assert.notNull((Object)mappings, (String)"mappings");
    }

    protected void constructors(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        String localName = model.getLocalRawName();
        String genericName = model.getLocalGenericName();
        boolean hasEntityFields = model.hasEntityFields();
        String thisOrSuper = hasEntityFields ? "this" : "super";
        this.constructorsForVariables(writer, model);
        if (!hasEntityFields) {
            writer.beginConstructor("PEntity<? extends " + genericName + "> entity");
            writer.line("super(entity.getType(),entity.getMetadata());");
            writer.end();
        }
        if (hasEntityFields) {
            writer.beginConstructor(PATH_METADATA);
            writer.line("this(metadata, metadata.isRoot() ? INITS : PathInits.DEFAULT);");
            writer.end();
        } else {
            if (!localName.equals(genericName)) {
                writer.suppressWarnings("unchecked");
            }
            writer.beginConstructor(PATH_METADATA);
            writer.line("super(", localName.equals(genericName) ? "" : "(Class)", localName, ".class, metadata);");
            writer.end();
        }
        if (hasEntityFields) {
            if (!localName.equals(genericName)) {
                writer.suppressWarnings("unchecked");
            }
            writer.beginConstructor(PATH_METADATA, "PathInits inits");
            writer.line(thisOrSuper, "(", localName.equals(genericName) ? "" : "(Class)", localName, ".class, metadata, inits);");
            writer.end();
        }
        if (hasEntityFields) {
            writer.beginConstructor("Class<? extends " + genericName + "> type", PATH_METADATA, "PathInits inits");
            writer.line("super(type, metadata, inits);");
            this.initEntityFields(writer, config, model);
            writer.end();
        }
    }

    protected void constructorsForVariables(CodeWriter writer, EntityType model) throws IOException {
        String thisOrSuper;
        String localName = model.getLocalRawName();
        String genericName = model.getLocalGenericName();
        boolean hasEntityFields = model.hasEntityFields();
        String string = thisOrSuper = hasEntityFields ? "this" : "super";
        if (!localName.equals(genericName)) {
            writer.suppressWarnings("unchecked");
        }
        writer.beginConstructor("String variable");
        writer.line(thisOrSuper, "(", localName.equals(genericName) ? "" : "(Class)", localName, ".class, forVariable(variable)", hasEntityFields ? ", INITS" : "", ");");
        writer.end();
    }

    protected void entityAccessor(EntityType model, Property field, CodeWriter writer) throws IOException {
        String queryType = this.typeMappings.getPathType(field.getType(), model, false);
        writer.beginMethod(queryType, field.getEscapedName(), new String[0]);
        writer.line("if (", field.getEscapedName(), " == null){");
        writer.line("    ", field.getEscapedName(), " = new ", queryType, "(forProperty(\"", field.getName(), "\"));");
        writer.line("}");
        writer.line("return ", field.getEscapedName(), ";");
        writer.end();
    }

    protected void entityField(EntityType model, Property field, SerializerConfig config, CodeWriter writer) throws IOException {
        String queryType = this.typeMappings.getPathType(field.getType(), model, false);
        if (field.isInherited()) {
            writer.line("// inherited");
        }
        if (config.useEntityAccessors()) {
            writer.protectedField(queryType, field.getEscapedName());
        } else {
            writer.publicFinal(queryType, field.getEscapedName());
        }
    }

    protected boolean hasOwnEntityProperties(EntityType model) {
        if (model.hasEntityFields()) {
            for (Property property : model.getProperties()) {
                if (property.isInherited() || property.getType().getCategory() != TypeCategory.ENTITY) continue;
                return true;
            }
        }
        return false;
    }

    protected void initEntityFields(CodeWriter writer, SerializerConfig config, EntityType model) throws IOException {
        Supertype superType = model.getSuperType();
        if (superType != null && superType.getEntityType().hasEntityFields()) {
            String superQueryType = this.typeMappings.getPathType(superType.getEntityType(), model, false);
            writer.line("this._super = new " + superQueryType + "(type, metadata, inits);");
        }
        for (Property field : model.getProperties()) {
            if (field.getType().getCategory() == TypeCategory.ENTITY) {
                this.initEntityField(writer, config, model, field);
                continue;
            }
            if (!field.isInherited() || superType == null || !superType.getEntityType().hasEntityFields()) continue;
            writer.line("this.", field.getEscapedName(), " = _super.", field.getEscapedName(), ";");
        }
    }

    private void initEntityField(CodeWriter writer, SerializerConfig config, EntityType model, Property field) throws IOException {
        String queryType = this.typeMappings.getPathType(field.getType(), model, false);
        if (!field.isInherited()) {
            writer.line("this." + field.getEscapedName() + " = ", "inits.isInitialized(\"" + field.getName() + "\") ? ", "new " + queryType + "(forProperty(\"" + field.getName() + "\")", field.getType().hasEntityFields() ? ", inits.get(\"" + field.getName() + "\")" : "", ") : null;");
        } else if (!config.useEntityAccessors()) {
            writer.line("this.", field.getEscapedName(), " = ", "_super.", field.getEscapedName(), ";");
        }
    }

    protected void intro(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        this.introPackage(writer, model);
        this.introImports(writer, config, model);
        writer.nl();
        this.introJavadoc(writer, model);
        this.introClassHeader(writer, model);
        this.introFactoryMethods(writer, model);
        this.introInits(writer, model);
        if (config.createDefaultVariable()) {
            this.introDefaultInstance(writer, model);
        }
        if (model.getSuperType() != null) {
            this.introSuper(writer, model);
        }
    }

    protected void introClassHeader(CodeWriter writer, EntityType model) throws IOException {
        Class pathType;
        String queryType = this.typeMappings.getPathType(model, model, true);
        String localName = model.getLocalGenericName();
        TypeCategory category = model.getOriginalCategory();
        switch (category) {
            case COMPARABLE: {
                pathType = PComparable.class;
                break;
            }
            case DATE: {
                pathType = PDate.class;
                break;
            }
            case DATETIME: {
                pathType = PDateTime.class;
                break;
            }
            case TIME: {
                pathType = PTime.class;
                break;
            }
            case NUMERIC: {
                pathType = PNumber.class;
                break;
            }
            default: {
                pathType = PEntity.class;
            }
        }
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        writer.beginClass(queryType, pathType.getSimpleName() + "<" + localName + ">", new String[0]);
        writer.privateStaticFinal("long", "serialVersionUID", String.valueOf(model.hashCode()));
    }

    protected void introDefaultInstance(CodeWriter writer, EntityType model) throws IOException {
        String simpleName = model.getUncapSimpleName();
        String queryType = this.typeMappings.getPathType(model, model, true);
        writer.publicStaticFinal(queryType, simpleName, "new " + queryType + "(\"" + simpleName + "\")");
    }

    protected void introFactoryMethods(CodeWriter writer, final EntityType model) throws IOException {
        String localName = model.getLocalRawName();
        String genericName = model.getLocalGenericName();
        for (Constructor c : model.getConstructors()) {
            if (!localName.equals(genericName)) {
                writer.suppressWarnings("unchecked");
            }
            writer.beginStaticMethod("EConstructor<" + genericName + ">", "create", c.getParameters(), new Transformer<Parameter, String>(){

                public String transform(Parameter p) {
                    return EntitySerializer.this.typeMappings.getExprType(p.getType(), model, false, false, true) + " " + p.getName();
                }
            });
            writer.beginLine("return new EConstructor<" + genericName + ">(");
            if (!localName.equals(genericName)) {
                writer.append("(Class)");
            }
            writer.append(localName + ".class");
            writer.append(", new Class[]{");
            boolean first = true;
            for (Parameter p : c.getParameters()) {
                if (!first) {
                    writer.append(", ");
                }
                if (p.getType().getPrimitiveName() != null) {
                    writer.append(p.getType().getPrimitiveName() + ".class");
                } else {
                    p.getType().appendLocalRawName(model, writer);
                    writer.append(".class");
                }
                first = false;
            }
            writer.append("}");
            for (Parameter p : c.getParameters()) {
                writer.append(", " + p.getName());
            }
            writer.append(");\n");
            writer.end();
        }
    }

    protected void introImports(CodeWriter writer, SerializerConfig config, EntityType model) throws IOException {
        writer.imports(PathMetadata.class.getPackage());
        writer.imports(PSimple.class.getPackage());
        writer.staticimports(PathMetadataFactory.class);
        if (!model.getConstructors().isEmpty() || !model.getMethods().isEmpty() || model.hasLists() && config.useListAccessors() || model.hasMaps() && config.useMapAccessors()) {
            writer.imports(EComparable.class.getPackage());
        }
        if (!model.getMethods().isEmpty()) {
            writer.imports(CSimple.class.getPackage());
        }
    }

    protected void introInits(CodeWriter writer, EntityType model) throws IOException {
        if (model.hasEntityFields()) {
            ArrayList<String> inits = new ArrayList<String>();
            for (Property property : model.getProperties()) {
                if (property.getType().getCategory() != TypeCategory.ENTITY) continue;
                for (String init : property.getInits()) {
                    inits.add(property.getEscapedName() + "." + init);
                }
            }
            if (!inits.isEmpty()) {
                inits.add(0, "*");
                writer.privateStaticFinal("PathInits", "INITS", "new PathInits(" + writer.join("\"", "\"", inits) + ")");
            } else {
                writer.privateStaticFinal("PathInits", "INITS", "PathInits.DIRECT");
            }
        }
    }

    protected void introJavadoc(CodeWriter writer, EntityType model) throws IOException {
        String simpleName = model.getSimpleName();
        String queryType = model.getPrefix() + simpleName;
        writer.javadoc(queryType + " is a Querydsl query type for " + simpleName);
    }

    protected void introPackage(CodeWriter writer, EntityType model) throws IOException {
        writer.packageDecl(model.getPackageName());
    }

    protected void introSuper(CodeWriter writer, EntityType model) throws IOException {
        EntityType superType = model.getSuperType().getEntityType();
        String superQueryType = this.typeMappings.getPathType(superType, model, false);
        if (!superType.hasEntityFields()) {
            writer.publicFinal(superQueryType, "_super", "new " + superQueryType + "(this)");
        } else {
            writer.publicFinal(superQueryType, "_super");
        }
    }

    protected void listAccessor(EntityType model, Property field, CodeWriter writer) throws IOException {
        String escapedName = field.getEscapedName();
        String queryType = this.typeMappings.getPathType(field.getParameter(0), model, false);
        writer.beginMethod(queryType, escapedName, "int index");
        writer.line("return " + escapedName + ".get(index);").end();
        writer.beginMethod(queryType, escapedName, "Expr<Integer> index");
        writer.line("return " + escapedName + ".get(index);").end();
    }

    protected void mapAccessor(EntityType model, Property field, CodeWriter writer) throws IOException {
        String escapedName = field.getEscapedName();
        String queryType = this.typeMappings.getPathType(field.getParameter(1), model, false);
        String keyType = field.getParameter(0).getLocalGenericName(model, false);
        String genericKey = field.getParameter(0).getLocalGenericName(model, true);
        writer.beginMethod(queryType, escapedName, keyType + " key");
        writer.line("return " + escapedName + ".get(key);").end();
        writer.beginMethod(queryType, escapedName, "Expr<" + genericKey + "> key");
        writer.line("return " + escapedName + ".get(key);").end();
    }

    protected void method(final EntityType model, Method method, SerializerConfig config, CodeWriter writer) throws IOException {
        String type = this.typeMappings.getExprType(method.getReturnType(), model, false, true, false);
        writer.beginMethod(type, method.getName(), method.getParameters(), new Transformer<Parameter, String>(){

            public String transform(Parameter p) {
                return EntitySerializer.this.typeMappings.getExprType(p.getType(), model, false, false, true) + " " + p.getName();
            }
        });
        String customClass = this.typeMappings.getCustomType(method.getReturnType(), model, true);
        writer.beginLine("return " + customClass + ".create(");
        String fullName = method.getReturnType().getFullName();
        if (!fullName.equals(String.class.getName()) && !fullName.equals(Boolean.class.getName())) {
            method.getReturnType().appendLocalRawName(model, writer);
            writer.append(".class, ");
        }
        writer.append("\"" + StringEscapeUtils.escapeJava((String)method.getTemplate()) + "\"");
        writer.append(", this");
        for (Parameter p : method.getParameters()) {
            writer.append(", " + p.getName());
        }
        writer.append(");\n");
        writer.end();
    }

    protected void outro(EntityType model, CodeWriter writer) throws IOException {
        writer.end();
    }

    @Override
    public void serialize(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        this.intro(model, config, writer);
        this.serializeProperties(model, config, writer);
        this.constructors(model, config, writer);
        for (Method method : model.getMethods()) {
            this.method(model, method, config, writer);
        }
        for (Property property : model.getProperties()) {
            TypeCategory category = property.getType().getCategory();
            if (category == TypeCategory.MAP && config.useMapAccessors()) {
                this.mapAccessor(model, property, writer);
                continue;
            }
            if (category == TypeCategory.LIST && config.useListAccessors()) {
                this.listAccessor(model, property, writer);
                continue;
            }
            if (category != TypeCategory.ENTITY || !config.useEntityAccessors()) continue;
            this.entityAccessor(model, property, writer);
        }
        this.outro(model, writer);
    }

    protected void serialize(EntityType model, Property field, String type, CodeWriter writer, String factoryMethod, String ... args) throws IOException {
        Supertype superType = model.getSuperType();
        StringBuilder value = new StringBuilder();
        if (field.isInherited() && superType != null) {
            if (!superType.getEntityType().hasEntityFields()) {
                value.append("_super." + field.getEscapedName());
            }
        } else {
            value.append(factoryMethod + "(\"" + field.getName() + "\"");
            for (String arg : args) {
                value.append(", " + arg);
            }
            value.append(")");
        }
        if (field.isInherited()) {
            writer.line("//inherited");
        }
        if (value.length() > 0) {
            writer.publicFinal(type, field.getEscapedName(), value.toString());
        } else {
            writer.publicFinal(type, field.getEscapedName());
        }
    }

    private void serializeProperties(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        for (Property property : model.getProperties()) {
            String queryType = this.typeMappings.getPathType(property.getType(), model, false);
            String localGenericName = property.getType().getLocalGenericName(model, true);
            String localRawName = property.getType().getLocalRawName(model);
            switch (property.getType().getCategory()) {
                case STRING: {
                    this.serialize(model, property, queryType, writer, "createString", new String[0]);
                    break;
                }
                case BOOLEAN: {
                    this.serialize(model, property, queryType, writer, "createBoolean", new String[0]);
                    break;
                }
                case SIMPLE: {
                    this.serialize(model, property, queryType, writer, "createSimple", localRawName + ".class");
                    break;
                }
                case COMPARABLE: {
                    this.serialize(model, property, queryType, writer, "createComparable", localRawName + ".class");
                    break;
                }
                case DATE: {
                    this.serialize(model, property, queryType, writer, "createDate", localRawName + ".class");
                    break;
                }
                case DATETIME: {
                    this.serialize(model, property, queryType, writer, "createDateTime", localRawName + ".class");
                    break;
                }
                case TIME: {
                    this.serialize(model, property, queryType, writer, "createTime", localRawName + ".class");
                    break;
                }
                case NUMERIC: {
                    this.serialize(model, property, queryType, writer, "createNumber", localRawName + ".class");
                    break;
                }
                case ARRAY: {
                    localGenericName = property.getParameter(0).getLocalGenericName(model, true);
                    this.serialize(model, property, "PArray<" + localGenericName + ">", writer, "createArray", localRawName + ".class");
                    break;
                }
                case COLLECTION: {
                    localGenericName = property.getParameter(0).getLocalGenericName(model, true);
                    localRawName = property.getParameter(0).getLocalRawName(model);
                    this.serialize(model, property, "PCollection<" + localGenericName + ">", writer, "createCollection", localRawName + ".class");
                    break;
                }
                case SET: {
                    localGenericName = property.getParameter(0).getLocalGenericName(model, true);
                    localRawName = property.getParameter(0).getLocalRawName(model);
                    this.serialize(model, property, "PSet<" + localGenericName + ">", writer, "createSet", localRawName + ".class");
                    break;
                }
                case MAP: {
                    String genericKey = property.getParameter(0).getLocalGenericName(model, true);
                    String genericValue = property.getParameter(1).getLocalGenericName(model, true);
                    String genericQueryType = this.typeMappings.getPathType(property.getParameter(1), model, false);
                    String keyType = property.getParameter(0).getLocalRawName(model);
                    String valueType = property.getParameter(1).getLocalRawName(model);
                    queryType = this.typeMappings.getPathType(property.getParameter(1), model, true);
                    this.serialize(model, property, "PMap<" + genericKey + ", " + genericValue + ", " + genericQueryType + ">", writer, "this.<" + genericKey + ", " + genericValue + ", " + genericQueryType + ">createMap", keyType + ".class", valueType + ".class", queryType + ".class");
                    break;
                }
                case LIST: {
                    localGenericName = property.getParameter(0).getLocalGenericName(model, true);
                    String genericQueryType = this.typeMappings.getPathType(property.getParameter(0), model, false);
                    localRawName = property.getParameter(0).getLocalRawName(model);
                    queryType = this.typeMappings.getPathType(property.getParameter(0), model, true);
                    this.serialize(model, property, "PList<" + localGenericName + ", " + genericQueryType + ">", writer, "createList", localRawName + ".class", queryType + ".class");
                    break;
                }
                case ENTITY: {
                    this.entityField(model, property, config, writer);
                }
            }
        }
    }
}

