/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query;

import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public final class QueryModifiers
implements Serializable {
    private static final long serialVersionUID = 2934344588433680339L;
    @Nullable
    private final Long limit;
    @Nullable
    private final Long offset;

    public static QueryModifiers limit(@Nonnegative long limit) {
        return new QueryModifiers(limit, null);
    }

    public static QueryModifiers offset(@Nonnegative long offset) {
        return new QueryModifiers(null, offset);
    }

    public QueryModifiers() {
        this.limit = null;
        this.offset = null;
    }

    public QueryModifiers(@Nullable Long limit, @Nullable Long offset) {
        this.limit = limit;
        if (limit != null && limit <= 0L) {
            throw new IllegalArgumentException("Limit must be greater than 0.");
        }
        this.offset = offset;
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("Offset must not be negative.");
        }
    }

    public QueryModifiers(QueryModifiers modifiers) {
        this.limit = modifiers.getLimit();
        this.offset = modifiers.getOffset();
    }

    @Nullable
    public Long getLimit() {
        return this.limit;
    }

    @Nullable
    public Long getOffset() {
        return this.offset;
    }

    public boolean isRestricting() {
        return this.limit != null || this.offset != null;
    }
}

