/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query;

import com.mysema.query.BooleanBuilder;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinType;
import com.mysema.query.QueryException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.types.Expr;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Path;
import com.mysema.query.types.expr.EBoolean;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class DefaultQueryMetadata
implements QueryMetadata,
Cloneable {
    private static final long serialVersionUID = 317736313966701232L;
    private boolean distinct;
    private Set<Expr<?>> exprInJoins = new HashSet();
    private List<Expr<?>> groupBy = new ArrayList();
    private BooleanBuilder having = new BooleanBuilder();
    private List<JoinExpression> joins = new ArrayList<JoinExpression>();
    @Nullable
    private QueryModifiers modifiers = new QueryModifiers();
    private List<OrderSpecifier<?>> orderBy = new ArrayList();
    private List<Expr<?>> projection = new ArrayList();
    private boolean unique;
    private BooleanBuilder where = new BooleanBuilder();

    @Override
    @SuppressWarnings(value={"GC_UNCHECKED_TYPE_IN_GENERIC_CALL"})
    public void addFrom(Expr<?> ... args) {
        for (Expr<?> arg : args) {
            if (arg instanceof Path) {
                this.ensureRoot((Path)((Object)arg));
            }
            if (this.exprInJoins.contains(arg)) continue;
            this.joins.add(new JoinExpression(JoinType.DEFAULT, arg));
            this.exprInJoins.add(arg);
        }
    }

    @Override
    public void addGroupBy(Expr<?> ... o) {
        this.groupBy.addAll(Arrays.asList(o));
    }

    @Override
    public void addHaving(EBoolean ... o) {
        for (EBoolean e : o) {
            if (BooleanBuilder.class.isInstance(e) && !((BooleanBuilder)e).hasValue()) continue;
            this.having.and(e);
        }
    }

    @Override
    @SuppressWarnings(value={"unchecked"})
    public void addJoin(JoinType joinType, Expr<?> expr) {
        if (!this.exprInJoins.contains(expr)) {
            if (expr instanceof Path && joinType == JoinType.DEFAULT) {
                this.ensureRoot((Path)((Object)expr));
            }
            this.joins.add(new JoinExpression(joinType, expr));
            this.exprInJoins.add(expr);
        }
    }

    @Override
    public void addJoinCondition(EBoolean o) {
        if (!this.joins.isEmpty()) {
            this.joins.get(this.joins.size() - 1).setCondition(o);
        }
    }

    @Override
    public void addOrderBy(OrderSpecifier<?> ... o) {
        this.orderBy.addAll(Arrays.asList(o));
    }

    @Override
    public void addProjection(Expr<?> ... o) {
        this.projection.addAll(Arrays.asList(o));
    }

    @Override
    public void addWhere(EBoolean ... o) {
        for (EBoolean e : o) {
            if (BooleanBuilder.class.isInstance(e) && !((BooleanBuilder)e).hasValue()) continue;
            this.where.and(e);
        }
    }

    @Override
    public void clearOrderBy() {
        this.orderBy = new ArrayList();
    }

    @Override
    public void clearProjection() {
        this.projection = new ArrayList();
    }

    @Override
    public void clearWhere() {
        this.where = new BooleanBuilder();
    }

    @Override
    public QueryMetadata clone() {
        try {
            DefaultQueryMetadata clone = (DefaultQueryMetadata)super.clone();
            clone.exprInJoins = new HashSet(this.exprInJoins);
            clone.groupBy = new ArrayList(this.groupBy);
            clone.having = this.having.clone();
            clone.joins = new ArrayList<JoinExpression>(this.joins);
            clone.modifiers = new QueryModifiers(this.modifiers);
            clone.orderBy = new ArrayList(this.orderBy);
            clone.projection = new ArrayList(this.projection);
            clone.where = this.where.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new QueryException(e);
        }
    }

    private void ensureRoot(Path<?> path) {
        if (path.getMetadata().getParent() != null) {
            throw new IllegalArgumentException("Only root paths are allowed for joins : " + path);
        }
    }

    @Override
    public List<? extends Expr<?>> getGroupBy() {
        return Collections.unmodifiableList(this.groupBy);
    }

    @Override
    public EBoolean getHaving() {
        return this.having.hasValue() ? this.having.getValue() : null;
    }

    @Override
    public List<JoinExpression> getJoins() {
        return Collections.unmodifiableList(this.joins);
    }

    @Override
    @Nullable
    public QueryModifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public List<OrderSpecifier<?>> getOrderBy() {
        return Collections.unmodifiableList(this.orderBy);
    }

    @Override
    public List<? extends Expr<?>> getProjection() {
        return Collections.unmodifiableList(this.projection);
    }

    @Override
    public EBoolean getWhere() {
        return this.where.hasValue() ? this.where.getValue() : null;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public void reset() {
        this.clearProjection();
        this.modifiers = new QueryModifiers();
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public void setLimit(Long limit) {
        this.modifiers = this.modifiers == null || this.modifiers.getOffset() == null ? QueryModifiers.limit(limit) : new QueryModifiers(limit, this.modifiers.getOffset());
    }

    @Override
    public void setModifiers(@Nullable QueryModifiers restriction) {
        this.modifiers = restriction;
    }

    @Override
    public void setOffset(Long offset) {
        this.modifiers = this.modifiers == null || this.modifiers.getLimit() == null ? QueryModifiers.offset(offset) : new QueryModifiers(this.modifiers.getLimit(), offset);
    }

    @Override
    public void setUnique(boolean unique) {
        this.unique = unique;
    }
}

